/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.theming.dao;

import com.dataiku.dip.dao.AbstractGlobalDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.theming.dao.DSSVisualizationThemeDAO;
import com.dataiku.dip.theming.model.DSSBuiltinThemesRegistry;
import com.dataiku.dip.theming.model.DSSVisualizationTheme;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedDSSVisualizationThemeDAO
extends AbstractGlobalDAO<DSSVisualizationTheme>
implements DSSVisualizationThemeDAO {
    public static final RelFile root = new RelFile(new String[]{"theming", "dss-visualization"});
    private final DSSBuiltinThemesRegistry dssBuiltinThemesRegistry;

    public FilesBasedDSSVisualizationThemeDAO(DSSBuiltinThemesRegistry dssBuiltinThemesRegistry) {
        this.dssBuiltinThemesRegistry = dssBuiltinThemesRegistry;
    }

    protected String getType() {
        return "DSS Visualization theme";
    }

    public void delete(String id) throws IOException {
        RelFile daoFile = this.getDAOFile(id);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.deleteFile(daoFile);
    }

    public int approximateCount() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(root)) {
            return 0;
        }
        return t.listFiles(root).size();
    }

    protected DSSVisualizationTheme getMandatory(String id, boolean unsafe) throws IOException {
        DSSVisualizationTheme obj = this.getOrNull(id, unsafe);
        if (obj == null) {
            throw new NotFoundException(this.getType() + " does not exist: " + id);
        }
        return obj;
    }

    protected DSSVisualizationTheme getOrNull(String id, boolean unsafe) throws IOException {
        RelFile file = this.getDAOFile(id);
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(file)) {
            return this.dssBuiltinThemesRegistry.get(id);
        }
        DSSVisualizationTheme theme = unsafe ? (DSSVisualizationTheme)t.readObjectUnsafe(file, DSSVisualizationTheme.class) : (DSSVisualizationTheme)t.readObject(file, DSSVisualizationTheme.class);
        theme.setId(id);
        return theme;
    }

    protected List<DSSVisualizationTheme> list(boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList dssVisualizationThemes = this.dssBuiltinThemesRegistry.getAll().entrySet().stream().filter(e -> !Objects.equals(e.getKey(), "__dku_dss_default_theme__")).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toCollection(ArrayList::new));
        if (t.isDirectory(root)) {
            for (RelFile file : t.listFiles(root)) {
                String id = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                dssVisualizationThemes.add(this.getMandatory(id, unsafe));
            }
        }
        return dssVisualizationThemes;
    }

    protected RelFile getDAOFile(String id) {
        return new RelFile(root, new String[]{id + ".json"});
    }

    @Override
    public void save(DSSVisualizationTheme DSSVisualizationTheme2) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        RelFile file = this.getDAOFile(DSSVisualizationTheme2.getId());
        tr.writeObject(file, (Object)DSSVisualizationTheme2);
    }
}

