/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.nodeclients.IUnifiedMonitoringClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDesignComputationService;
import com.dataiku.dip.unifiedmonitoring.payloads.UnifiedMonitoringProxySMVWithModelStatus;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalDesignNode
implements IUnifiedMonitoringClient {
    private final ProjectsService projectsService;
    private final TransactionService transactionService;
    private final UnifiedMonitoringDesignComputationService unifiedMonitoringDesignComputationService;
    private final AuthCtx authCtx;

    public LocalDesignNode(AuthCtx authCtx) {
        this.authCtx = authCtx;
        this.projectsService = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
        this.transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        this.unifiedMonitoringDesignComputationService = (UnifiedMonitoringDesignComputationService)SpringUtils.getBean(UnifiedMonitoringDesignComputationService.class);
    }

    @Override
    public ProjectsService.UIProject getProjectSummary(String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            ProjectsService.UIProject uIProject = this.projectsService.getSummary(this.authCtx, projectKey);
            return uIProject;
        }
    }

    @Override
    public ModelStatus getModelStatus(@Nonnull String projectKey, @Nonnull String fullModelId, @Nullable List<String> mesToFilterOn) throws Exception {
        return this.unifiedMonitoringDesignComputationService.getOrComputeModelStatus(projectKey, FullModelId.parse(fullModelId), null);
    }

    @Override
    public List<UnifiedMonitoringProxySMVWithModelStatus> listProxyModelVersionWithModelStatus() throws Exception {
        return this.unifiedMonitoringDesignComputationService.listProxySmvWithModelStatus();
    }

    @Override
    public void close() throws Exception {
    }
}

