/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringPaths;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.MonitoredManagedApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.project.MonitoredProjectDeployment;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.api.client.util.Preconditions;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringDeployerCRUDService {
    private final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedModelDeployerCRUDService");

    public List<AbstractMonitoredProjectDeployment> listMonitoredProjectDeployments(List<String> projectDeploymentsIds) {
        Preconditions.checkNotNull(projectDeploymentsIds, (Object)"The list of deployments ids can not be null.");
        File deploymentMonitoringDir = UnifiedMonitoringPaths.getProjectDeployerDeploymentsBaseDir();
        ArrayList<AbstractMonitoredProjectDeployment> list = new ArrayList<AbstractMonitoredProjectDeployment>();
        if (deploymentMonitoringDir.exists() && deploymentMonitoringDir.isDirectory()) {
            for (File deploymentMonitoringFile : Objects.requireNonNull(deploymentMonitoringDir.listFiles())) {
                String deploymentId = deploymentMonitoringFile.getName().replaceAll(".json$", "");
                if (!projectDeploymentsIds.contains(deploymentId) || !deploymentMonitoringFile.isFile()) continue;
                try {
                    list.add(MonitoredProjectDeployment.readMonitoredProjectDeployment(deploymentMonitoringFile, deploymentId));
                }
                catch (Exception e) {
                    this.logger.warn((Object)String.format("Unable to read project monitoring %s, skipping", deploymentMonitoringFile.getName()), (Throwable)e);
                }
            }
        }
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (AbstractMonitoredProjectDeployment monitoredProjectDeployment : list) {
            String displayedName = monitoredProjectDeployment.displayedName;
            counter.put(displayedName, counter.getOrDefault(displayedName, 0) + 1);
        }
        for (AbstractMonitoredProjectDeployment monitoredProjectDeployment : list) {
            if ((Integer)counter.get(monitoredProjectDeployment.displayedName) <= 1) continue;
            monitoredProjectDeployment.displayedName = monitoredProjectDeployment.displayedName + " (" + monitoredProjectDeployment.deploymentId + ")";
        }
        return list;
    }

    public void save(AbstractMonitoredProjectDeployment monitoredProjectDeployment) throws IOException {
        Preconditions.checkNotNull((Object)monitoredProjectDeployment.deploymentId, (Object)"Project deployment id can not be null");
        File projectMonitoringDeploymentDir = UnifiedMonitoringPaths.getProjectDeployerDeploymentsBaseDir();
        DKUFileUtils.mkdirs((File)projectMonitoringDeploymentDir);
        monitoredProjectDeployment.snapshotTimestamp = System.currentTimeMillis();
        JSON.prettyToFile((Object)monitoredProjectDeployment, (File)new File(projectMonitoringDeploymentDir, monitoredProjectDeployment.deploymentId + ".json"));
    }

    public List<MonitoredManagedApiEndpoint> listMonitoredManagedApiEndpoints(List<String> deploymentsIds) {
        Preconditions.checkNotNull(deploymentsIds, (Object)"The list of deployments ids can not be null.");
        ArrayList<MonitoredManagedApiEndpoint> list = new ArrayList<MonitoredManagedApiEndpoint>();
        for (String deploymentId : deploymentsIds) {
            File endpointMonitoringDir = UnifiedMonitoringPaths.getApiDeployerEndpointsBaseDir(deploymentId);
            if (!endpointMonitoringDir.exists() || !endpointMonitoringDir.isDirectory()) continue;
            for (File endpointMonitoringFile : Objects.requireNonNull(endpointMonitoringDir.listFiles(f -> f.getName().endsWith(".json")))) {
                try {
                    MonitoredManagedApiEndpoint monitoredManagedApiEndpoint = MonitoredManagedApiEndpoint.readMonitoredManagedApiEndpoint(endpointMonitoringFile, deploymentId);
                    list.add(monitoredManagedApiEndpoint);
                }
                catch (Exception e) {
                    this.logger.warn((Object)String.format("Unable to read api endpoint monitoring %s, skipping", endpointMonitoringFile.getName()), (Throwable)e);
                }
            }
        }
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (MonitoredManagedApiEndpoint endpointMonitoring : list) {
            String displayedName = endpointMonitoring.displayedName;
            counter.put(displayedName, counter.getOrDefault(displayedName, 0) + 1);
        }
        for (MonitoredManagedApiEndpoint endpointMonitoring : list) {
            if ((Integer)counter.get(endpointMonitoring.displayedName) <= 1) continue;
            endpointMonitoring.displayedName = endpointMonitoring.displayedName + " (" + endpointMonitoring.deploymentId + ")";
        }
        return list;
    }

    public List<MonitoredExternalApiEndpoint> listMonitoredExternalApiEndpoints(List<String> externalEndpointsScopeNames) {
        return externalEndpointsScopeNames.stream().map(this::listMonitoredExternalApiEndpoints).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<MonitoredExternalApiEndpoint> listMonitoredExternalApiEndpoints(String externalEndpointsScopeName) {
        ArrayList<MonitoredExternalApiEndpoint> list = new ArrayList<MonitoredExternalApiEndpoint>();
        File externalEndpointsScopeDir = UnifiedMonitoringPaths.getExternalEndpointsDeploymentsBaseDir(externalEndpointsScopeName);
        if (externalEndpointsScopeDir.exists() && externalEndpointsScopeDir.isDirectory()) {
            for (File endpointMonitoringFile : Objects.requireNonNull(externalEndpointsScopeDir.listFiles())) {
                if (!endpointMonitoringFile.isFile()) continue;
                try {
                    list.add(MonitoredExternalApiEndpoint.readMonitoredExternalApiEndpoint(endpointMonitoringFile));
                }
                catch (Exception e) {
                    this.logger.warn((Object)String.format("Unable to read external endpoint monitoring %s, skipping", endpointMonitoringFile.getName()), (Throwable)e);
                }
            }
        }
        return list;
    }

    public void deleteMonitoredExternalApiEndpoint(String externalEndpointsScopeName, String endpointName) {
        this.logger.infoV("Deleting snapshot of external endpoint %s of scope %s", new Object[]{endpointName, externalEndpointsScopeName});
        File monitoringFile = UnifiedMonitoringPaths.getExternalEndpointMonitoring(externalEndpointsScopeName, endpointName);
        try {
            DKUFileUtils.forceDelete((File)monitoringFile);
        }
        catch (IOException e) {
            this.logger.warnV((Throwable)e, "The endpoint %s of the scope %s cannot be deleted", new Object[]{endpointName, externalEndpointsScopeName});
        }
    }

    public void deleteExternalEndpointSnapshots(String externalEndpointScopeName) throws IOException {
        Preconditions.checkNotNull((Object)externalEndpointScopeName, (Object)"The externalEndpointScopeName can not be null");
        this.logger.infoV("Deleting external endpoint snapshots of scope %s", new Object[]{externalEndpointScopeName});
        File externalEndpointScopeFolder = UnifiedMonitoringPaths.getExternalEndpointsDeploymentsBaseDir(externalEndpointScopeName);
        if (externalEndpointScopeFolder.exists() && externalEndpointScopeFolder.isDirectory()) {
            FileUtils.deleteDirectory((File)externalEndpointScopeFolder);
        } else {
            this.logger.warnV("The external endpoint scope directory %s is not found. Cannot perform deletion of monitorings", new Object[]{externalEndpointScopeName});
        }
    }

    public void deleteManagedApiEndpointSnapshots(String deploymentId) throws IOException {
        Preconditions.checkNotNull((Object)deploymentId, (Object)"The deploymentId cannot be null");
        this.logger.infoV("Deleting monitoring snapshot of dss deployment %s", new Object[]{deploymentId});
        File deploymentsMonitoringDir = UnifiedMonitoringPaths.getApiDeployerEndpointsBaseDir(deploymentId);
        if (deploymentsMonitoringDir.exists() && deploymentsMonitoringDir.isDirectory()) {
            FileUtils.forceDelete((File)deploymentsMonitoringDir);
        } else {
            this.logger.warnV("Deployment monitoring snapshot of %s is not found", new Object[]{deploymentId});
        }
    }

    public void deleteUnusedManagedApiEndpointSnapshots(String deploymentId, Collection<String> configuredEndpointIds) {
        Preconditions.checkNotNull((Object)deploymentId, (Object)"The deploymentId cannot be null");
        Preconditions.checkNotNull(configuredEndpointIds, (Object)"The configuredEndpointIds cannot be null");
        this.logger.infoV("Deleting monitoring snapshot of deployment %s for the endpoints not in: %s", new Object[]{deploymentId, configuredEndpointIds.toString()});
        File deploymentsMonitoringDir = UnifiedMonitoringPaths.getApiDeployerEndpointsBaseDir(deploymentId);
        if (deploymentsMonitoringDir.exists() && deploymentsMonitoringDir.isDirectory()) {
            for (File endpointMonitoringFile : FileUtils.listFiles((File)deploymentsMonitoringDir, (String[])new String[]{"json"}, (boolean)false)) {
                String endpointId = FilenameUtils.getBaseName((String)endpointMonitoringFile.getName());
                if (!endpointMonitoringFile.isFile() || configuredEndpointIds.contains(endpointId)) continue;
                this.logger.infoV("Deleting monitoring snapshot of endpoint %s of deployment %s", new Object[]{endpointId, deploymentId});
                try {
                    DKUFileUtils.delete((File)endpointMonitoringFile);
                }
                catch (IOException e) {
                    this.logger.errorV((Throwable)e, "Failed to delete %s, skipping", new Object[]{endpointMonitoringFile});
                }
            }
        } else {
            this.logger.warnV("Deployment monitoring snapshot of %s is not found", new Object[]{deploymentId});
        }
    }

    public void deleteProjectSnapshot(String deploymentId) {
        Preconditions.checkNotNull((Object)deploymentId, (Object)"The deploymentId cannot be null");
        this.logger.infoV("Deleting monitoring snapshot of project deployment %s", new Object[]{deploymentId});
        File deploymentMonitoringFile = UnifiedMonitoringPaths.getProjectDeployerDeployment(deploymentId);
        if (deploymentMonitoringFile.exists() && deploymentMonitoringFile.isFile()) {
            try {
                DKUFileUtils.delete((File)deploymentMonitoringFile);
            }
            catch (IOException e) {
                this.logger.errorV((Throwable)e, "Failed to delete %s, skipping", new Object[]{deploymentMonitoringFile});
            }
        } else {
            this.logger.warnV("Deployment monitoring snapshot of %s is not found", new Object[]{deploymentId});
        }
    }

    public void save(MonitoredManagedApiEndpoint monitoredManagedApiEndpoint) throws IOException {
        Preconditions.checkNotNull((Object)monitoredManagedApiEndpoint.deploymentId, (Object)"Api endpoint deployment id can not be null");
        Preconditions.checkNotNull((Object)monitoredManagedApiEndpoint.endpointName, (Object)"Api endpoint name id can not be null");
        File apiEndpointDeploymentsBaseDir = UnifiedMonitoringPaths.getApiDeployerEndpointsBaseDir(monitoredManagedApiEndpoint.deploymentId);
        DKUFileUtils.mkdirs((File)apiEndpointDeploymentsBaseDir);
        monitoredManagedApiEndpoint.snapshotTimestamp = System.currentTimeMillis();
        JSON.prettyToFile((Object)monitoredManagedApiEndpoint, (File)new File(apiEndpointDeploymentsBaseDir, monitoredManagedApiEndpoint.endpointName + ".json"));
    }

    public void save(String externalEndpointsScopeName, List<MonitoredExternalApiEndpoint> monitoredExternalApiEndpoints) throws IOException {
        Preconditions.checkNotNull((Object)externalEndpointsScopeName, (Object)"External api endpoint connection name can not be null");
        File externalEndpointDeploymentsBaseDir = UnifiedMonitoringPaths.getExternalEndpointsDeploymentsBaseDir(externalEndpointsScopeName);
        if (externalEndpointDeploymentsBaseDir.exists() && externalEndpointDeploymentsBaseDir.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)externalEndpointDeploymentsBaseDir);
        }
        DKUFileUtils.mkdirs((File)externalEndpointDeploymentsBaseDir);
        for (MonitoredExternalApiEndpoint monitoredExternalApiEndpoint : monitoredExternalApiEndpoints) {
            monitoredExternalApiEndpoint.snapshotTimestamp = System.currentTimeMillis();
            JSON.prettyToFile((Object)monitoredExternalApiEndpoint, (File)new File(externalEndpointDeploymentsBaseDir, monitoredExternalApiEndpoint.endpointName + ".json"));
        }
    }
}

