/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.shaker.text.Labelled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ParamDesc {
    public static final String STRING = "string";
    public static final String PASSWORD = "password";
    public static final String TEXTAREA = "textarea";
    public static final String INT = "int";
    public static final String DOUBLE = "double";
    public static final String BOOLEAN = "boolean";
    public static final String SIMPLE_SELECT = "simple_select";
    public static final String ADVANCED_SELECT = "advanced_select";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String TIMEZONE = "timezone";
    public static final String AUTOCONFIG = "autoconfig";
    String name;
    String type;
    String label;
    String tooltip;
    String placeholder;
    Object defaultValue;
    public List<com.dataiku.dip.autoconfig.ParamDesc> params;
    boolean mandatory = true;
    boolean canBeEmpty = false;
    public Double minD;
    public Double maxD;
    public Integer minI;
    public Integer maxI;
    public List<SelectValue> advancedChoices;
    public List<String> choices;

    public static String[] enumValues(Class<? extends Enum<?>> theEnum) {
        Enum<?>[] e = theEnum.getEnumConstants();
        String[] names = new String[e.length];
        for (int i = 0; i < e.length; ++i) {
            names[i] = e[i].name();
        }
        return names;
    }

    public static String[] capitalize(String[] strs) {
        String[] out = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            out[i] = StringUtils.capitalize((String)strs[i].toLowerCase());
        }
        return out;
    }

    public static ParamDesc string(String name, String label) {
        return new ParamDesc(name, STRING).withLabel(label);
    }

    public static ParamDesc string(String name, String label, String tooltip) {
        return new ParamDesc(name, STRING).withLabel(label).withTooltip(tooltip);
    }

    public static ParamDesc string(String name, String label, String tooltip, String defaultValue) {
        return new ParamDesc(name, STRING).withLabel(label).withTooltip(tooltip).withDefaultValue(defaultValue);
    }

    public static ParamDesc password(String name, String label, String tooltip) {
        return new ParamDesc(name, PASSWORD).withLabel(label).withTooltip(tooltip);
    }

    public static ParamDesc timezone(String name, String label, String tooltip) {
        return new ParamDesc(name, TIMEZONE).withLabel(label).withTooltip(tooltip);
    }

    public static ParamDesc textarea(String name, String label) {
        return new ParamDesc(name, TEXTAREA).withLabel(label);
    }

    public static ParamDesc textarea(String name, String label, String tooltip) {
        return new ParamDesc(name, TEXTAREA).withLabel(label).withTooltip(tooltip);
    }

    public static ParamDesc textarea(String name, String label, String tooltip, String defaultValue) {
        return new ParamDesc(name, TEXTAREA).withLabel(label).withTooltip(tooltip).withDefaultValue(defaultValue);
    }

    public static ParamDesc intP(String name, String label) {
        return new ParamDesc(name, INT).withLabel(label);
    }

    public static ParamDesc intP(String name, String label, String tooltip) {
        return new ParamDesc(name, INT).withLabel(label).withTooltip(tooltip);
    }

    public static ParamDesc intP(String name, String label, String tooltip, int defaultValue) {
        return new ParamDesc(name, INT).withLabel(label).withTooltip(tooltip).withDefaultValue(defaultValue);
    }

    public static ParamDesc doubleP(String name, String label) {
        return new ParamDesc(name, DOUBLE).withLabel(label);
    }

    public static ParamDesc doubleP(String name, String label, String tooltip) {
        return new ParamDesc(name, DOUBLE).withLabel(label).withTooltip(tooltip);
    }

    public static ParamDesc doubleP(String name, String label, String tooltip, double defaultValue) {
        return new ParamDesc(name, DOUBLE).withLabel(label).withTooltip(tooltip).withDefaultValue(defaultValue);
    }

    public static ParamDesc booleanP(String name, String label) {
        return new ParamDesc(name, BOOLEAN).withLabel(label).withMandatory(false).withCanBeEmpty(true);
    }

    public static ParamDesc booleanP(String name, String label, String tooltip) {
        return new ParamDesc(name, BOOLEAN).withLabel(label).withTooltip(tooltip).withMandatory(false).withCanBeEmpty(true);
    }

    public static ParamDesc booleanP(String name, String label, String tooltip, boolean defaultValue) {
        return new ParamDesc(name, BOOLEAN).withLabel(label).withTooltip(tooltip).withMandatory(false).withCanBeEmpty(true).withDefaultValue(defaultValue);
    }

    public static ParamDesc simpleSelect(String name, String label, String tooltip, String ... choices) {
        ParamDesc pd = new ParamDesc(name, SIMPLE_SELECT).withLabel(label).withTooltip(tooltip);
        pd.choices = new ArrayList<String>();
        Collections.addAll(pd.choices, choices);
        return pd;
    }

    public static ParamDesc advancedSelect(String name, String label, String tooltip, String[] choiceValues, String[] choiceLabels) {
        ParamDesc pd = new ParamDesc(name, ADVANCED_SELECT).withLabel(label).withTooltip(tooltip);
        pd.advancedChoices = new ArrayList<SelectValue>();
        for (int i = 0; i < choiceValues.length; ++i) {
            SelectValue sv = new SelectValue();
            sv.value = choiceValues[i];
            sv.label = choiceLabels[i];
            pd.advancedChoices.add(sv);
        }
        return pd;
    }

    public static <E extends Enum<E>> ParamDesc advancedSelect(String name, String label, String tooltip, Class<E> choiceEnum) {
        return ParamDesc.advancedSelect(name, label, tooltip, choiceEnum, "en");
    }

    public static <E extends Enum<E>> ParamDesc advancedSelect(String name, String label, String tooltip, Class<E> choiceEnum, String language) {
        ParamDesc pd = new ParamDesc(name, ADVANCED_SELECT).withLabel(label).withTooltip(tooltip);
        pd.advancedChoices = new ArrayList<SelectValue>();
        for (Enum choice : (Enum[])choiceEnum.getEnumConstants()) {
            SelectValue sv = new SelectValue();
            sv.value = choice.name();
            sv.label = ((Labelled)((Object)choice)).getLabel(language);
            pd.advancedChoices.add(sv);
        }
        return pd;
    }

    public ParamDesc(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ParamDesc withLabel(String label) {
        this.label = label;
        return this;
    }

    public ParamDesc withTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ParamDesc withPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public ParamDesc withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ParamDesc withMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public ParamDesc withCanBeEmpty(boolean canBeEmpty) {
        this.canBeEmpty = canBeEmpty;
        return this;
    }

    public ParamDesc withMaxI(Integer maxI) {
        this.maxI = maxI;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.defaultValue.toString();
    }

    static class SelectValue {
        String value;
        String label;

        SelectValue() {
        }
    }
}

