/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.PythonInterpreterFactory;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class VariablesUpdateRunner {
    private final String PYTHON_FUNCTION_NAME = "get_variables";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.variables.update");

    public void doUpdate(RWTransactionRef t) throws Exception {
        GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)t.readObjectDefault("general-settings.json", GeneralSettingsDAO.GeneralSettings.class);
        if (gs.variablesUpdateConfig == null) {
            return;
        }
        this.doUpdate(t, gs.variablesUpdateConfig.globalVariablesCode);
    }

    public void doUpdate(RWTransactionRef t, String updateCode) throws Exception {
        if (!StringUtils.isBlank((String)updateCode)) {
            logger.info((Object)"Creating Python interpreter for variables update");
            try (PythonInterpreter interpreter = PythonInterpreterFactory.newInstance(true);){
                interpreter.exec(updateCode);
                PyObject entryPoint = interpreter.get("get_variables");
                if (entryPoint == null) {
                    throw ErrorContext.iae((String)"Function get_variables not found in variables update code");
                }
                JsonObject globalVariables = (JsonObject)t.readObject("variables.json", JsonObject.class);
                PyObject variablesObj = entryPoint.__call__();
                if (!(variablesObj instanceof PyDictionary)) {
                    throw new IllegalArgumentException("The function get_variables must return a map of updated variables");
                }
                PyDictionary variablesDict = (PyDictionary)variablesObj;
                logger.info((Object)("Got an update for " + variablesDict.size() + " variables"));
                for (Object varName : variablesDict.keySet()) {
                    String varNameStr = (String)varName;
                    Object val = variablesDict.get(varName);
                    String valStr = null;
                    if (val == null) {
                        throw new IllegalArgumentException("Can't handle returned null for " + varNameStr);
                    }
                    valStr = val.toString();
                    logger.infoV("New value: %s = %s (%s)", new Object[]{varNameStr, valStr, val.getClass()});
                    if (val instanceof Number) {
                        globalVariables.addProperty(varNameStr, (Number)val);
                        continue;
                    }
                    if (val instanceof Boolean) {
                        globalVariables.addProperty(varNameStr, (Boolean)val);
                        continue;
                    }
                    if (val instanceof String) {
                        globalVariables.addProperty(varNameStr, valStr);
                        continue;
                    }
                    throw new IllegalArgumentException("Can't handle returned value type (" + String.valueOf(val.getClass()) + " for variable " + varNameStr);
                }
                logger.info((Object)("Saving variables: " + globalVariables.toString()));
                t.writeStringUTF8("variables.json", JSON.prettyUnescapeHtml((Object)globalVariables));
            }
            catch (PyException e) {
                throw ErrorContext.iae((String)(String.valueOf(e.type) + " : " + String.valueOf(e.value)));
            }
        }
    }
}

