/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.client;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.HttpMultipartMode;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ContentBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.FileBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.StringBody;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.dataiku.lambda.model.serverconfig.EndpointServerSideConfig;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.serverconfig.ServiceSummaryState;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class LambdaAdminAPIClient
extends APIKeyAuthAPIClient {
    public LambdaAdminAPIClient(String uri, String key, boolean trustAllSSLCertificates, ProxySettings proxySettings, int connectTimeout, int socketTimeout) {
        super(uri, key, trustAllSSLCertificates, proxySettings, connectTimeout, socketTimeout);
    }

    protected String getPossibleBadInfraHint() {
        return ", please check URL of infra (" + this.baseURI + ") or server version";
    }

    public List<ServiceSummaryState> listServices() throws IOException {
        JsonArray ret = (JsonArray)this.get("admin/api/services/", JsonArray.class);
        return (List)JSON.parse((String)JSON.json((Object)ret), (TypeToken)new TypeToken<List<ServiceSummaryState>>(){});
    }

    public JsonObject isAlive(boolean checkAdmin) throws IOException {
        return (JsonObject)this.get("isAlive/" + (checkAdmin ? "?checkAdmin=true" : ""), JsonObject.class);
    }

    public void createService(String serviceId, boolean ignoreIfExists) throws IOException {
        String url = "admin/api/services" + (ignoreIfExists ? "?ignoreIfExists=true" : "");
        this.postObject(url, Void.class, JF.obj().with("serviceId", serviceId).get());
    }

    public void deleteService(String serviceId) throws IOException {
        this.delete("admin/api/services/" + serviceId, Void.class, new Object[0]);
    }

    public void importGenerationFromFile(String serviceId, File packageFile) throws IOException {
        FileBody fileBody = new FileBody(packageFile, ContentType.DEFAULT_BINARY);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)fileBody);
        builder.addPart("serviceId", (ContentBody)new StringBody(serviceId, ContentType.MULTIPART_FORM_DATA));
        HttpEntity entity = builder.build();
        this.postAnyToJSON(this.serviceURL(serviceId, "generations/actions/importFromStream"), Void.class, entity);
    }

    public List<LambdaServiceGenTag.WithStatus> listGenerations(String serviceId) throws IOException {
        JsonObject obj = (JsonObject)this.getForm(this.serviceURL(serviceId, "generations"), JsonObject.class, new Object[0]);
        return (List)JSON.parse((String)JSON.json((Object)obj.get("generations")), (TypeToken)new TypeToken<List<LambdaServiceGenTag.WithStatus>>(){});
    }

    public GenerationsMapping getCurrentMapping(String serviceId) throws IOException {
        return (GenerationsMapping)this.getForm(this.serviceURL(serviceId, "mapping"), GenerationsMapping.class, new Object[0]);
    }

    public void switchToNewest(String serviceId) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/actions/switchToNewest"), Void.class, new JsonObject());
    }

    public void setGenerationsMapping(String serviceId, GenerationsMapping generationsMapping) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/actions/setMapping"), Void.class, generationsMapping);
    }

    public void resetEndpointsSettings(String serviceId) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/actions/reset-endpoints-settings"), Void.class, new JsonObject());
    }

    public void setEndpointSettings(String serviceId, String endpointId, EndpointServerSideConfig config) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/endpoints/" + endpointId + "/settings"), Void.class, config);
    }

    public LambdaServerConfig.AuditLog getAuditLogSettings() throws IOException {
        return (LambdaServerConfig.AuditLog)this.get("admin/api/audit-settings", LambdaServerConfig.AuditLog.class);
    }

    public void setAuditLogSettings(LambdaServerConfig.AuditLog al) throws IOException {
        this.postObject("admin/api/audit-settings", Void.class, al);
    }

    public void setActivityMonitoringSettings(ActivityMonitoringSettings settings) throws IOException {
        this.postObject("admin/api/activity-monitoring-settings", Void.class, settings);
    }

    public void disableService(String serviceId) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/actions/disable"), Void.class, new JsonObject());
    }

    public void enableService(String serviceId) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/actions/enable"), Void.class, new JsonObject());
    }

    public void setServiceNotAlive(String serviceId) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/actions/setNotAlive"), Void.class, new JsonObject());
    }

    public void setServiceAlive(String serviceId) throws IOException {
        this.postObject(this.serviceURL(serviceId, "/actions/setAlive"), Void.class, new JsonObject());
    }

    public String getActivityMetrics() throws IOException {
        return this.postFormToStringV("/admin/api/activity-metrics", new Object[0]);
    }

    public String getSystemMetrics() throws IOException {
        return this.postFormToStringV("/admin/api/system-metrics", new Object[0]);
    }

    private String serviceURL(String serviceId, String suffix) {
        return "admin/api/services/" + serviceId + "/" + suffix;
    }
}

