/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectValues
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        JSONObject prev = DKUFormulaUtils.asJSONObject(args[0]);
        ArrayList<Object> ret = new ArrayList<Object>();
        Iterator it = prev.keys();
        try {
            while (it.hasNext()) {
                Object k = it.next();
                Object v = prev.get(k.toString());
                ret.add(v);
            }
        }
        catch (JSONException e) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " error: " + e.getMessage());
        }
        return ret;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ObjectValues.DOCUMENTATION", "Returns the values of an object as an array.").withParams("object o").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions").withExample(Example.with("{\"name\":\"Smith\",\"age\":42}").returns("[\"Smith\",42]"));
    }
}

