/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.List;
import java.util.Properties;

public class Avg
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires at least one argument");
        }
        List<?> input = DKUFormulaUtils.asList(args);
        int nonEmptyValuesCount = 0;
        double total = 0.0;
        for (Object arg : input) {
            Double value = DKUDoubles.tryParse((String)String.valueOf(arg));
            if (value == null) continue;
            total += value.doubleValue();
            ++nonEmptyValuesCount;
        }
        return nonEmptyValuesCount != 0 ? total / (double)nonEmptyValuesCount : 0.0;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Avg.DOCUMENTATION", "Computes the average of the numbers in an array. Skips non-number elements from the array.").withParams("array a | value1, value2 ...").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("[1, 2, 3]").returns("2.0")).withExample(Example.with("1, 2, 3").returns("2.0")).withExample(Example.with("[[10, 11], 1, 2, \"string\", 3]").returns("2.0")).withExample(Example.with("[10, 11], 1, 2, \"string\", 3").returns("2.0")).withExample(Example.with("\"[1, 2, 3]\"").returns("2.0"));
    }
}

