/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Even
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1 && args[0] != null && args[0] instanceof Number) {
            Number n = (Number)args[0];
            if (n instanceof Long || n instanceof Integer || n instanceof Short) {
                return Even.roundUpToEven(n.longValue());
            }
            return Even.roundUpToEven(n.doubleValue());
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a number");
    }

    public static double roundUpToEven(double d) {
        double temp = Math.ceil(d);
        return temp % 2.0 == 0.0 ? temp : temp + 1.0;
    }

    public static long roundUpToEven(long l) {
        return l % 2L == 0L ? l : l + 1L;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Even.DOCUMENTATION", "Rounds a number up to the nearest even integer.").withParams("number d").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("3").returns("4.0")).withExample(Example.with("2.3").returns("4.0")).withExample(Example.with("-2.3").returns("-2.0")).withExample(Example.with("-3").returns("-2.0"));
    }
}

