/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.udaf;

import com.google.refine.expr.functions.aggregations.AvgAgg;
import com.google.refine.expr.functions.aggregations.CountAgg;
import com.google.refine.expr.functions.aggregations.CountdAgg;
import com.google.refine.expr.functions.aggregations.MaxAgg;
import com.google.refine.expr.functions.aggregations.MedianAgg;
import com.google.refine.expr.functions.aggregations.MinAgg;
import com.google.refine.expr.functions.aggregations.PercentileAgg;
import com.google.refine.expr.functions.aggregations.StdevAgg;
import com.google.refine.expr.functions.aggregations.StdevPopAgg;
import com.google.refine.expr.functions.aggregations.SumAgg;
import com.google.refine.expr.functions.aggregations.VarAgg;
import com.google.refine.expr.functions.aggregations.VarPopAgg;
import com.google.refine.grel.Control;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;

public class UdafControlFunctionRegistry
extends ControlFunctionRegistry {
    private static final UdafControlFunctionRegistry INSTANCE = new UdafControlFunctionRegistry();

    public static UdafControlFunctionRegistry getInstance() {
        return INSTANCE;
    }

    private UdafControlFunctionRegistry() {
        this.registerFunctions();
    }

    public void registerFunctions() {
        GrelControlFunctionRegistry.getInstance().getFunctionMapping().forEach(d -> this.registerFunction((String)d.getKey(), (Function)d.getValue()));
        GrelControlFunctionRegistry.getInstance().getControlMapping().forEach(d -> this.registerControl((String)d.getKey(), (Control)d.getValue()));
        this.registerFunction("sum", new SumAgg());
        this.registerFunction("avg", new AvgAgg());
        this.registerFunction("max", new MaxAgg());
        this.registerFunction("min", new MinAgg());
        this.registerFunction("count", new CountAgg());
        this.registerFunction("stdev", new StdevAgg());
        this.registerFunction("stdevp", new StdevPopAgg());
        this.registerFunction("var", new VarAgg());
        this.registerFunction("varp", new VarPopAgg());
        this.registerFunction("countd", new CountdAgg());
        this.registerFunction("percentile", new PercentileAgg());
        this.registerFunction("median", new MedianAgg());
    }
}

