/*
 * Decompiled with CFR 0.152.
 */
package com.tlarsendataguy.yxdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class Spatial {
    private static final int BytesPerPoint = 16;

    public static String ToGeoJson(byte[] value) throws IllegalArgumentException {
        if (value == null) {
            return "";
        }
        if (value.length < 20) {
            throw new IllegalArgumentException("bytes are not a spatial object");
        }
        ByteBuffer buffer = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN);
        int objType = buffer.getInt(0);
        switch (objType) {
            case 8: {
                return Spatial.ParsePoints(buffer);
            }
            case 3: {
                return Spatial.ParseLines(buffer);
            }
            case 5: {
                return Spatial.ParsePoly(buffer);
            }
        }
        throw new IllegalArgumentException("bytes are not a spatial object");
    }

    private static String ParsePoints(ByteBuffer value) {
        int totalPoints = value.getInt(36);
        if (totalPoints == 1) {
            return Spatial.ParseSinglePoint(value);
        }
        return Spatial.ParseMultiPoint(value);
    }

    private static String ParseSinglePoint(ByteBuffer value) {
        return Spatial.GeoJson("Point", Spatial.GetCoordAt(value, 40));
    }

    private static String ParseMultiPoint(ByteBuffer value) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        for (int i = 40; i < value.capacity(); i += 16) {
            points.add(Spatial.GetCoordAt(value, i));
        }
        return Spatial.GeoJson("MultiPoint", points);
    }

    private static String ParseLines(ByteBuffer value) {
        ArrayList<ArrayList<double[]>> lines = Spatial.ParseMultiPointObjects(value);
        if (lines.size() == 1) {
            return Spatial.GeoJson("LineString", lines.get(0));
        }
        return Spatial.GeoJson("MultiLineString", lines);
    }

    private static String ParsePoly(ByteBuffer value) {
        ArrayList<ArrayList<double[]>> poly = Spatial.ParseMultiPointObjects(value);
        if (poly.size() == 1) {
            return Spatial.GeoJson("Polygon", poly);
        }
        ArrayList<ArrayList<ArrayList<double[]>>> coordinates = new ArrayList<ArrayList<ArrayList<double[]>>>();
        coordinates.add(poly);
        return Spatial.GeoJson("MultiPolygon", coordinates);
    }

    private static ArrayList<ArrayList<double[]>> ParseMultiPointObjects(ByteBuffer value) {
        int[] endingIndices = Spatial.GetEndingIndices(value);
        int i = 48 + endingIndices.length * 4 - 4;
        ArrayList<ArrayList<double[]>> objects = new ArrayList<ArrayList<double[]>>();
        for (int endingIndex : endingIndices) {
            ArrayList<double[]> line = new ArrayList<double[]>();
            while (i < endingIndex) {
                line.add(Spatial.GetCoordAt(value, i));
                i += 16;
            }
            objects.add(line);
        }
        return objects;
    }

    private static int[] GetEndingIndices(ByteBuffer value) {
        int totalObjects = value.getInt(36);
        int totalPoints = (int)value.getLong(40);
        int[] endingIndices = new int[totalObjects];
        int i = 48;
        int startAt = 48 + (totalObjects - 1) * 4;
        for (int j = 1; j < totalObjects; ++j) {
            int endingIndex;
            int endingPoint = value.getInt(i);
            endingIndices[j - 1] = endingIndex = endingPoint * 16 + startAt;
            i += 4;
        }
        endingIndices[totalObjects - 1] = totalPoints * 16 + startAt;
        return endingIndices;
    }

    private static double[] GetCoordAt(ByteBuffer value, int at) {
        double lng = value.getDouble(at);
        double lat = value.getDouble(at + 8);
        return new double[]{lng, lat};
    }

    private static String GeoJson(String objType, Object coordinates) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"type\":\"");
        builder.append(objType);
        builder.append("\",\"coordinates\":");
        Spatial.CoordinatesToJson(builder, coordinates);
        builder.append('}');
        return builder.toString();
    }

    private static void CoordinatesToJson(StringBuilder builder, Object coordinates) {
        if (coordinates instanceof List) {
            List items = (List)coordinates;
            builder.append('[');
            boolean first = true;
            for (Object item : items) {
                if (!first) {
                    builder.append(',');
                }
                Spatial.CoordinatesToJson(builder, item);
                first = false;
            }
            builder.append(']');
            return;
        }
        if (coordinates instanceof double[]) {
            double[] items = (double[])coordinates;
            builder.append('[');
            boolean first = true;
            for (double item : items) {
                if (!first) {
                    builder.append(',');
                }
                Spatial.CoordinatesToJson(builder, item);
                first = false;
            }
            builder.append(']');
            return;
        }
        builder.append(coordinates);
    }
}

