/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop.gcp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.common.io.BaseEncoding;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class RefreshTokenAuth2Provider
implements AccessTokenProvider {
    private static Logger logger = Logger.getLogger(RefreshTokenAuth2Provider.class);
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    public static final String CONFIG_ACCESS_TOKEN = "fs.gs.auth.access.token";
    public static final String CONFIG_ACCESS_TOKEN_EXPIRE_TIME = "fs.gs.auth.access.token.expires.on";
    public static final String CONFIG_REFRESH_TOKEN = "fs.gs.auth.refresh.token";
    public static final String CONFIG_TOKEN_ENDPOINT = "fs.gs.auth.token.endpoint";
    public static final String CONFIG_CLIENT_ID = "fs.gs.auth.client.id";
    public static final String CONFIG_CLIENT_SECRET = "fs.gs.auth.client.secret";
    public static final String CONFIG_PROXY_ADDRESS = "fs.gs.proxy.address";
    public static final String CONFIG_PROXY_USERNAME = "fs.gs.proxy.username";
    public static final String CONFIG_PROXY_PASSWORD = "fs.gs.proxy.password";
    private static final AccessTokenProvider.AccessToken EXPIRED_TOKEN = new AccessTokenProvider.AccessToken("", Long.valueOf(-1L));
    private Configuration config;
    public static Map<String, AccessTokenProvider.AccessToken> latestAccessTokensByInitialRefreshToken = new ConcurrentHashMap<String, AccessTokenProvider.AccessToken>();

    public AccessTokenProvider.AccessToken getAccessToken() {
        String refreshToken = this.config.get(CONFIG_REFRESH_TOKEN);
        refreshToken = refreshToken == null || refreshToken.isBlank() ? "" : refreshToken;
        AccessTokenProvider.AccessToken accessToken = latestAccessTokensByInitialRefreshToken.getOrDefault(refreshToken, this.getDefaultAccessToken());
        logger.debug((Object)("Using access token, which is set to expire at '" + dateFormat.format(Instant.ofEpochMilli(accessToken.getExpirationTimeMilliSeconds())) + "' and it is now '" + dateFormat.format(Instant.now()) + "'"));
        return accessToken;
    }

    private AccessTokenProvider.AccessToken getDefaultAccessToken() {
        String accessTokenFromConfig = this.config.get(CONFIG_ACCESS_TOKEN);
        long accessTokenExpireTime = Long.parseLong(this.config.get(CONFIG_ACCESS_TOKEN_EXPIRE_TIME, "0"));
        if (accessTokenFromConfig != null) {
            return new AccessTokenProvider.AccessToken(accessTokenFromConfig, Long.valueOf(accessTokenExpireTime));
        }
        return EXPIRED_TOKEN;
    }

    public void refresh() {
        AccessTokenProvider.AccessToken accessToken;
        String tokenEndpoint = this.config.get(CONFIG_TOKEN_ENDPOINT);
        String refreshToken = this.config.get(CONFIG_REFRESH_TOKEN);
        String clientId = this.config.get(CONFIG_CLIENT_ID);
        String clientSecret = this.config.get(CONFIG_CLIENT_SECRET);
        String proxyAddress = this.config.get(CONFIG_PROXY_ADDRESS);
        String proxyUsername = this.config.get(CONFIG_PROXY_USERNAME);
        String proxyPassword = this.config.get(CONFIG_PROXY_PASSWORD);
        refreshToken = refreshToken == null || refreshToken.isBlank() ? "" : refreshToken;
        AccessTokenProvider.AccessToken previousAccessToken = this.getAccessToken();
        if (!Instant.ofEpochMilli(previousAccessToken.getExpirationTimeMilliSeconds()).isBefore(Instant.now().plus(1L, ChronoUnit.MINUTES))) {
            logger.debug((Object)"Access token expires in more than 1 minute, it's probably been refreshed by another thread.");
            return;
        }
        logger.debug((Object)"Refreshing access-token based token");
        logger.debug((Object)("Refresh token calling endpoint '" + tokenEndpoint + "' with client id '" + clientId + "'"));
        logger.debug((Object)("Proxy setup: '" + proxyAddress + "' with username = '" + proxyUsername + "'"));
        try {
            accessToken = this.getAccessToken(tokenEndpoint, clientId, clientSecret, refreshToken, proxyAddress, proxyUsername, proxyPassword);
            logger.debug((Object)("New token expires at '" + dateFormat.format(Instant.ofEpochMilli(accessToken.getExpirationTimeMilliSeconds())) + "'"));
        }
        catch (IOException e) {
            accessToken = EXPIRED_TOKEN;
            logger.error((Object)"Couldn't refresh token", (Throwable)e);
        }
        latestAccessTokensByInitialRefreshToken.put(refreshToken, accessToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenProvider.AccessToken getAccessToken(String tokenEndpoint, String clientId, String clientSecret, String refreshToken, String proxyAddress, final String proxyUsername, final String proxyPassword) throws IOException {
        AccessTokenProvider.AccessToken token;
        block7: {
            HttpURLConnection conn = null;
            logger.debug((Object)"Get a new access token using the refresh token grant flow");
            try {
                URL url = new URL(tokenEndpoint);
                conn = (HttpURLConnection)url.openConnection(this.getProxy(proxyAddress));
                conn.setRequestMethod("POST");
                conn.setReadTimeout(30000);
                conn.setConnectTimeout(30000);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Accept", "application/json");
                if (proxyUsername != null) {
                    logger.debug((Object)"Setup the request with the proxy auth");
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + BaseEncoding.base64().encode((proxyUsername + ":" + proxyPassword).getBytes(StandardCharsets.UTF_8)));
                    Authenticator authenticator = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(proxyUsername, proxyPassword.toCharArray());
                        }
                    };
                    Authenticator.setDefault(authenticator);
                }
                conn.setDoOutput(true);
                String payload = "grant_type=refresh_token&refresh_token=" + refreshToken + "&client_id=" + clientId + "&client_secret=" + clientSecret;
                conn.getOutputStream().write(payload.getBytes("UTF-8"));
                int httpResponseCode = conn.getResponseCode();
                logger.debug((Object)("Response " + httpResponseCode));
                String responseContentType = conn.getHeaderField("Content-Type");
                if (httpResponseCode == 200 && responseContentType.startsWith("application/json")) {
                    logger.debug((Object)"Received a 200 with presumably a new access token");
                    InputStream httpResponseStream = conn.getInputStream();
                    token = this.parseTokenFromStream(httpResponseStream);
                    break block7;
                }
                logger.debug((Object)"Refresh token grant flow failed");
                InputStream stream = conn.getErrorStream();
                if (stream == null) {
                    stream = conn.getInputStream();
                }
                String responseBody = this.consumeInputStream(stream);
                throw new IOException("Refresh token failed with response '" + responseBody + "' with code '" + httpResponseCode + "'");
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return token;
    }

    private String consumeInputStream(InputStream stream) throws IOException {
        String responseLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "utf-8"));
        StringBuilder response = new StringBuilder();
        while ((responseLine = br.readLine()) != null) {
            response.append(responseLine.trim());
        }
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenProvider.AccessToken parseTokenFromStream(InputStream httpResponseStream) throws IOException {
        AccessTokenProvider.AccessToken token;
        try {
            int expirationPeriodInSecs = 0;
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createJsonParser(httpResponseStream);
            jp.nextToken();
            String accessTokenFromResponse = "";
            while (jp.hasCurrentToken()) {
                if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    String fieldValue = jp.getText();
                    if (fieldName.equals("access_token")) {
                        accessTokenFromResponse = fieldValue;
                    }
                    if (fieldName.equals("expires_in")) {
                        expirationPeriodInSecs = Integer.parseInt(fieldValue);
                    }
                }
                jp.nextToken();
            }
            token = new AccessTokenProvider.AccessToken(accessTokenFromResponse, Long.valueOf(System.currentTimeMillis() + (long)expirationPeriodInSecs * 1000L));
            jp.close();
        }
        finally {
            httpResponseStream.close();
        }
        return token;
    }

    public Proxy getProxy(String proxyAddress) {
        if (proxyAddress == null) {
            return Proxy.NO_PROXY;
        }
        logger.debug((Object)"The proxy is defined");
        String[] proxyAddressParsed = proxyAddress.split(":");
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAddressParsed[0], Integer.parseInt(proxyAddressParsed[1])));
    }

    public void setConf(Configuration config) {
        this.config = config;
    }

    public Configuration getConf() {
        return this.config;
    }
}

