/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/data-quality"})
public class PublicAPIDataQualityController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ReadOnlyJobsInternalDB readOnlyJobsInternalDB;

    @AuditedCall(value={"msgType", "instance-data-quality"})
    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, DataQualityProjectAPI> getDataQualityMonitoredProjectSummary(HttpServletRequest req) throws Exception {
        List projects;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            projects = this.projectsService.listAccessibleUnsafe(authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        Map dataQualityProjectPointMap = this.readOnlyJobsInternalDB.getLastDataQualityProjectStatusesForList(projects.stream().map(ProjectsService.UIProject::getProjectKey).collect(Collectors.toList()));
        HashMap<String, DataQualityProjectAPI> result = new HashMap<String, DataQualityProjectAPI>();
        for (Map.Entry entry : dataQualityProjectPointMap.entrySet()) {
            result.put((String)entry.getKey(), new DataQualityProjectAPI((ReadOnlyJobsInternalDB.DataQualityProjectPoint)entry.getValue()));
        }
        return result;
    }

    public static class DataQualityProjectAPI {
        long ruleLastRunDate;
        int okCount;
        int warningCount;
        int errorCount;
        int emptyCount;

        public DataQualityProjectAPI(ReadOnlyJobsInternalDB.DataQualityProjectPoint point) {
            this.ruleLastRunDate = point.lastRunRuleComputeTime;
            this.okCount = point.last.okCount;
            this.warningCount = point.last.warningCount;
            this.errorCount = point.last.errorCount;
            this.emptyCount = point.last.emptyCount;
        }
    }
}

