/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.codestudio.CodeStudioCodes;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/admin/code-envs"})
public class PublicAPICodeEnvsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeCodeEnvsService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeCodeEnvsService;
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    @Autowired
    private AvailablePythonInterpretersService availablePythonInterpretersService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private CodeStudioTemplatesService codeStudioTemplatesService;
    private static final Logger logger = Logger.getLogger((String)"dip.public.code-envs");

    @AuditedCall(value={"msgType", "admin-code-envs-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
        }
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeCodeEnvsService.listCodeEnvsWithKernelSpecNames_NT());
                break;
            }
            case DESIGN: {
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeCodeEnvsService.listCodeEnvsWithKernelSpecNames_NT());
                break;
            }
            default: {
                throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-get"})
    @RequestMapping(value={"/{envLang}/{envName:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, this.getAutomationUIEnv(authCtx, el, envName));
                break;
            }
            case DESIGN: {
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, this.getDesignUIEnv(authCtx, el, envName));
                break;
            }
            default: {
                throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-delete", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/{envLang}/{envName:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName) throws Exception {
        AuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, new Privileges.CodeEnvLevelPrivilegeType[]{Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS});
        }
        logger.info((Object)("Deleting " + envName + " of type " + String.valueOf(el)));
        FutureResponse fr = switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> this.automationNodeCodeEnvsService.startEnvDelete(authCtx, el, envName);
            case ApplicationConfigurator.DSSNodeType.DESIGN -> this.designNodeCodeEnvsService.startEnvDelete(authCtx, el, envName);
            default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
        };
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
    }

    @AuditedCall(value={"msgType", "admin-internal-code-env-create", "codeEnvVersion", "${codeEnvVersion}", "pythonInterpreter", "${pythonInterpreter}", "dssInternalCodeEnvType", "${dssInternalCodeEnvType}"})
    @RequestMapping(value={"/internal-env/create"})
    public void addInternal(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) @Nullable String codeEnvVersion, @RequestParam(required=false) @Nullable String pythonInterpreter, @RequestParam String dssInternalCodeEnvType) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCreateCodeEnvPrivilege(authCtx);
        }
        DSSInternalCodeEnvsService.DSSInternalCodeEnvType envType = (DSSInternalCodeEnvsService.DSSInternalCodeEnvType)this.parseEnumFromString(dssInternalCodeEnvType, DSSInternalCodeEnvsService.DSSInternalCodeEnvType.class);
        if (pythonInterpreter == null) {
            Optional optionalPythonInterpreter = DSSInternalCodeEnvsService.getPreferredInstalledInterpreterOrNull((DSSInternalCodeEnvsService.DSSInternalCodeEnvType)envType, (String)codeEnvVersion, (List)this.availablePythonInterpretersService.getAvailablePythonInterpreters());
            if (optionalPythonInterpreter.isEmpty()) {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, String.format("No supported interpreter installed on this machine for the '%s' internal code environment.", envType));
            }
            pythonInterpreter = ((StandardPythonInterpreter)optionalPythonInterpreter.get()).toString();
        } else {
            pythonInterpreter = ((StandardPythonInterpreter)this.parseEnumFromString(pythonInterpreter, StandardPythonInterpreter.class)).toString();
        }
        Optional codeEnvListItem = this.dssInternalCodeEnvsService.getCodeEnv_NT(envType, codeEnvVersion);
        if (codeEnvListItem.isPresent()) {
            PublicAPICodeEnvsController.sendErrorFromThrowableNoStack((Throwable)new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_EXISTING_ENV, String.format("The specified code env '%s' already exists.", envType)), (int)409, (HttpServletResponse)resp);
            return;
        }
        FutureResponse futureResponse = this.dssInternalCodeEnvsService.createCodeEnv(authCtx, envType, codeEnvVersion, pythonInterpreter.toUpperCase());
        futureResponse = this.futureService.waitForFinalResponse(futureResponse);
        PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)futureResponse.result);
    }

    @AuditInline
    @RequestMapping(value={"/{envLang}/{envName:.+}"}, method={RequestMethod.POST})
    public void add(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName) throws Exception {
        AuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCreateCodeEnvPrivilege(authCtx);
        }
        try {
            FutureResponse fr = switch (ApplicationConfigurator.getNodeType()) {
                case ApplicationConfigurator.DSSNodeType.AUTOMATION -> {
                    CodeEnvModel.AutomationNewEnvSpec spec = (CodeEnvModel.AutomationNewEnvSpec)this.getRequestBodyAs(req, CodeEnvModel.AutomationNewEnvSpec.class);
                    if (CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL.equals((Object)spec.deploymentMode)) {
                        throw new IllegalArgumentException("Manual creation of a DSS_INTERNAL code environment is disabled. Please use the dedicated API for internal code environment creation");
                    }
                    spec.envLang = el;
                    spec.envName = envName;
                    logger.info((Object)("Creating " + envName + " of type " + String.valueOf(el) + " with spec " + JSON.json((Object)spec)));
                    yield this.automationNodeCodeEnvsService.startCreateEnv(authCtx, spec);
                }
                case ApplicationConfigurator.DSSNodeType.DESIGN -> {
                    switch (el) {
                        case PYTHON: {
                            CodeEnvModel.DesignNewPythonEnvSpec spec = (CodeEnvModel.DesignNewPythonEnvSpec)this.getRequestBodyAs(req, CodeEnvModel.DesignNewPythonEnvSpec.class);
                            if (CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL.equals((Object)spec.deploymentMode)) {
                                throw new IllegalArgumentException("Manual creation of a DSS_INTERNAL code environment is disabled. Please use the dedicated API for internal code environment creation.");
                            }
                            spec.envName = envName;
                            spec.initializeCorePackageSetBasedOnInterpreter();
                            logger.info((Object)("Creating " + envName + " of type " + String.valueOf(el) + " with spec " + JSON.json((Object)spec)));
                            yield this.designNodeCodeEnvsService.startCreatePythonEnv(authCtx, spec);
                        }
                        case R: {
                            CodeEnvModel.DesignNewREnvSpec spec = (CodeEnvModel.DesignNewREnvSpec)this.getRequestBodyAs(req, CodeEnvModel.DesignNewREnvSpec.class);
                            if (CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL.equals((Object)spec.deploymentMode)) {
                                throw new IllegalArgumentException("Manual creation of a DSS_INTERNAL code environment is disabled. Please use the dedicated API for internal code environment creation.");
                            }
                            spec.envName = envName;
                            logger.info((Object)("Creating " + envName + " of type " + String.valueOf(el) + " with spec " + JSON.json((Object)spec)));
                            yield this.designNodeCodeEnvsService.startCreateREnv(authCtx, spec);
                        }
                    }
                    throw new Error("unreachable");
                }
                default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
            };
            fr = this.futureService.waitForFinalResponse(fr);
            PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
            this.auditTrailService.generic("admin-code-envs-create").with("envName", envName).with("envLang", el.name()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-code-envs-create", (Throwable)e).with("envName", envName).with("envLang", el.name()).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-update", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/{envLang}/{envName:.+}"}, method={RequestMethod.PUT})
    public void modify(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName) throws Exception {
        AuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        boolean canManagePermissions = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, new Privileges.CodeEnvLevelPrivilegeType[]{Privileges.CodeEnvLevelPrivilegeType.UPDATE});
            canManagePermissions = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
        }
        logger.info((Object)("Updating " + envName + " of type " + String.valueOf(el)));
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                switch (el) {
                    case PYTHON: {
                        CodeEnvModel.AutomationUIPythonEnv pythonEnv = (CodeEnvModel.AutomationUIPythonEnv)this.getRequestBodyAs(req, CodeEnvModel.AutomationUIPythonEnv.class);
                        CodeEnvModel.AutomationUIPythonEnv currentEnv = this.automationNodeCodeEnvsService.getPythonEnvForUI(envName, true);
                        this.modifyAutomationEnv(currentEnv, pythonEnv, authCtx, canManagePermissions);
                        break;
                    }
                    case R: {
                        CodeEnvModel.AutomationUIREnv rEnv = (CodeEnvModel.AutomationUIREnv)this.getRequestBodyAs(req, CodeEnvModel.AutomationUIREnv.class);
                        CodeEnvModel.AutomationUIREnv currentEnv = this.automationNodeCodeEnvsService.getREnvForUI(envName, true);
                        this.modifyAutomationEnv(currentEnv, rEnv, authCtx, canManagePermissions);
                        break;
                    }
                    default: {
                        throw new Error("unreachable");
                    }
                }
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, this.getAutomationUIEnv(authCtx, el, envName));
                break;
            }
            case DESIGN: {
                switch (el) {
                    case PYTHON: {
                        CodeEnvModel.DesignUIPythonEnv pythonUIEnv = (CodeEnvModel.DesignUIPythonEnv)this.getRequestBodyAs(req, CodeEnvModel.DesignUIPythonEnv.class);
                        CodeEnvModel.DesignUIPythonEnv currentEnv = this.designNodeCodeEnvsService.getPythonEnvForUI(envName, true);
                        this.modifyDesignEnv(currentEnv, pythonUIEnv, authCtx, canManagePermissions);
                        break;
                    }
                    case R: {
                        CodeEnvModel.DesignUIREnv rUIEnv = (CodeEnvModel.DesignUIREnv)this.getRequestBodyAs(req, CodeEnvModel.DesignUIREnv.class);
                        CodeEnvModel.DesignUIREnv currentEnv = this.designNodeCodeEnvsService.getREnvForUI(envName, true);
                        this.modifyDesignEnv(currentEnv, rUIEnv, authCtx, canManagePermissions);
                        break;
                    }
                    default: {
                        throw new Error("unreachable");
                    }
                }
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, this.getDesignUIEnv(authCtx, el, envName));
                break;
            }
            default: {
                throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
            }
        }
    }

    private <T extends CodeEnvModel.AbstractEnvDesc> void modifyCommonDesignEnv(CodeEnvModel.AbstractDesignUIEnv<T> currentEnv, CodeEnvModel.AbstractDesignUIEnv<T> uiEnv, boolean mayUpdatePermissions) {
        if (mayUpdatePermissions) {
            if (currentEnv.envLang == CodeEnvModel.EnvLang.PYTHON || currentEnv.envLang == CodeEnvModel.EnvLang.R) {
                currentEnv.desc.owner = uiEnv.desc.owner;
            }
            currentEnv.usableByAll = uiEnv.usableByAll;
            currentEnv.permissions = uiEnv.permissions;
        }
        currentEnv.desc.externalCondaEnvName = uiEnv.externalCondaEnvName;
        currentEnv.specCondaEnvironment = uiEnv.specCondaEnvironment;
        currentEnv.specPackageList = uiEnv.specPackageList;
        currentEnv.rebuildDependentCodeStudioTemplates = uiEnv.rebuildDependentCodeStudioTemplates;
        currentEnv.desc.envSettings = uiEnv.desc.envSettings;
        currentEnv.allContainerConfs = uiEnv.allContainerConfs;
        currentEnv.containerConfs = uiEnv.containerConfs;
        currentEnv.allSparkKubernetesConfs = uiEnv.allSparkKubernetesConfs;
        currentEnv.sparkKubernetesConfs = uiEnv.sparkKubernetesConfs;
        currentEnv.desc.containerCacheBustingLocation = uiEnv.containerCacheBustingLocation;
        currentEnv.desc.dockerfileAtStart = uiEnv.dockerfileAtStart;
        currentEnv.desc.dockerfileBeforePackages = uiEnv.dockerfileBeforePackages;
        currentEnv.desc.dockerfileAfterCondaPackages = uiEnv.dockerfileAfterCondaPackages;
        currentEnv.desc.dockerfileAfterPackages = uiEnv.dockerfileAfterPackages;
        currentEnv.desc.dockerfileAtEnd = uiEnv.dockerfileAtEnd;
    }

    private void modifyDesignEnv(CodeEnvModel.DesignUIREnv currentEnv, CodeEnvModel.DesignUIREnv uiEnv, AuthCtx authCtx, boolean mayUpdatePermissions) throws IOException {
        this.modifyCommonDesignEnv((CodeEnvModel.AbstractDesignUIEnv)currentEnv, (CodeEnvModel.AbstractDesignUIEnv)uiEnv, mayUpdatePermissions);
        ((CodeEnvModel.REnvDesc)currentEnv.desc).installCorePackages = ((CodeEnvModel.REnvDesc)uiEnv.desc).installCorePackages;
        ((CodeEnvModel.REnvDesc)currentEnv.desc).installJupyterSupport = ((CodeEnvModel.REnvDesc)uiEnv.desc).installJupyterSupport;
        ((CodeEnvModel.REnvDesc)currentEnv.desc).yarnRBin = ((CodeEnvModel.REnvDesc)uiEnv.desc).yarnRBin;
        this.designNodeCodeEnvsService.saveEnvForUI(authCtx, currentEnv.envLang, currentEnv.envName, (CodeEnvModel.AbstractDesignUIEnv)currentEnv, true);
    }

    private void modifyDesignEnv(CodeEnvModel.DesignUIPythonEnv currentEnv, CodeEnvModel.DesignUIPythonEnv uiEnv, AuthCtx authCtx, boolean mayUpdatePermissions) throws IOException {
        this.modifyCommonDesignEnv((CodeEnvModel.AbstractDesignUIEnv)currentEnv, (CodeEnvModel.AbstractDesignUIEnv)uiEnv, mayUpdatePermissions);
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).useReferenceSpec = ((CodeEnvModel.PythonEnvDesc)uiEnv.desc).useReferenceSpec;
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).installCorePackages = ((CodeEnvModel.PythonEnvDesc)uiEnv.desc).installCorePackages;
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).corePackagesSet = ((CodeEnvModel.PythonEnvDesc)uiEnv.desc).corePackagesSet;
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).installJupyterSupport = ((CodeEnvModel.PythonEnvDesc)uiEnv.desc).installJupyterSupport;
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).yarnPythonBin = ((CodeEnvModel.PythonEnvDesc)uiEnv.desc).yarnPythonBin;
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).dockerImageResources = ((CodeEnvModel.PythonEnvDesc)uiEnv.desc).dockerImageResources;
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).updateResourcesApiNode = ((CodeEnvModel.PythonEnvDesc)uiEnv.desc).updateResourcesApiNode;
        currentEnv.resourcesInitScript = uiEnv.resourcesInitScript;
        ((CodeEnvModel.PythonEnvDesc)currentEnv.desc).predefinedContainerHooks = uiEnv.predefinedContainerHooks;
        this.designNodeCodeEnvsService.saveEnvForUI(authCtx, currentEnv.envLang, currentEnv.envName, (CodeEnvModel.AbstractDesignUIEnv)currentEnv, true);
    }

    private void modifyAutomationEnv(CodeEnvModel.AutomationUIREnv currentEnv, CodeEnvModel.AutomationUIREnv uiEnv, AuthCtx authCtx, boolean mayUpdatePermissions) throws Exception {
        this.modifyAutomationEnvCommons((CodeEnvModel.AutomationUIEnv)currentEnv, (CodeEnvModel.AutomationUIEnv)uiEnv, mayUpdatePermissions);
        this.modifyAutomationEnvVersions((CodeEnvModel.AutomationUIEnv)currentEnv, (CodeEnvModel.AutomationUIEnv)uiEnv, (BiConsumer)this::modifyAutomationEnvVersion);
        this.automationNodeCodeEnvsService.saveEnvForUI(authCtx, currentEnv.envLang, currentEnv.envName, (CodeEnvModel.AutomationUIEnv)currentEnv, true);
    }

    private void modifyAutomationEnv(CodeEnvModel.AutomationUIPythonEnv currentEnv, CodeEnvModel.AutomationUIPythonEnv uiEnv, AuthCtx authCtx, boolean mayUpdatePermissions) throws Exception {
        this.modifyAutomationEnvCommons((CodeEnvModel.AutomationUIEnv)currentEnv, (CodeEnvModel.AutomationUIEnv)uiEnv, mayUpdatePermissions);
        this.modifyAutomationEnvVersions((CodeEnvModel.AutomationUIEnv)currentEnv, (CodeEnvModel.AutomationUIEnv)uiEnv, (BiConsumer)this::modifyAutomationEnvVersion);
        this.automationNodeCodeEnvsService.saveEnvForUI(authCtx, currentEnv.envLang, currentEnv.envName, (CodeEnvModel.AutomationUIEnv)currentEnv, true);
    }

    private <T extends CodeEnvModel.AbstractAutomationUIEnvVersion<?>> void modifyAutomationEnvCommons(CodeEnvModel.AutomationUIEnv<T> currentEnv, CodeEnvModel.AutomationUIEnv<T> uiEnv, boolean mayUpdatePermissions) {
        currentEnv.envSettings = uiEnv.envSettings;
        currentEnv.allContainerConfs = uiEnv.allContainerConfs;
        currentEnv.containerConfs = uiEnv.containerConfs;
        currentEnv.allSparkKubernetesConfs = uiEnv.allSparkKubernetesConfs;
        currentEnv.sparkKubernetesConfs = uiEnv.sparkKubernetesConfs;
        currentEnv.rebuildDependentCodeStudioTemplates = uiEnv.rebuildDependentCodeStudioTemplates;
        if (mayUpdatePermissions) {
            currentEnv.owner = uiEnv.owner;
            currentEnv.usableByAll = uiEnv.usableByAll;
            currentEnv.permissions = uiEnv.permissions;
        }
    }

    private void modifyAutomationEnvVersion(CodeEnvModel.AutomationUIREnvVersion currentVersion, CodeEnvModel.AutomationUIREnvVersion uiVersion) {
        ((CodeEnvModel.REnvDesc)currentVersion.desc).externalCondaEnvName = ((CodeEnvModel.REnvDesc)uiVersion.desc).externalCondaEnvName;
        ((CodeEnvModel.REnvDesc)currentVersion.desc).installCorePackages = ((CodeEnvModel.REnvDesc)uiVersion.desc).installCorePackages;
        ((CodeEnvModel.REnvDesc)currentVersion.desc).installJupyterSupport = ((CodeEnvModel.REnvDesc)uiVersion.desc).installJupyterSupport;
        ((CodeEnvModel.REnvDesc)currentVersion.desc).yarnRBin = ((CodeEnvModel.REnvDesc)uiVersion.desc).yarnRBin;
    }

    private void modifyAutomationEnvVersion(CodeEnvModel.AutomationUIPythonEnvVersion currentVersion, CodeEnvModel.AutomationUIPythonEnvVersion uiVersion) {
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).externalCondaEnvName = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).externalCondaEnvName;
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).useReferenceSpec = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).useReferenceSpec;
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).installCorePackages = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).installCorePackages;
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).corePackagesSet = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).corePackagesSet;
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).installJupyterSupport = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).installJupyterSupport;
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).yarnPythonBin = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).yarnPythonBin;
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).dockerImageResources = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).dockerImageResources;
        ((CodeEnvModel.PythonEnvDesc)currentVersion.desc).updateResourcesApiNode = ((CodeEnvModel.PythonEnvDesc)uiVersion.desc).updateResourcesApiNode;
        currentVersion.resourcesInitScript = uiVersion.resourcesInitScript;
        currentVersion.predefinedContainerHooks = uiVersion.predefinedContainerHooks;
    }

    private <TVersion extends CodeEnvModel.AbstractAutomationUIEnvVersion<?>> void modifyAutomationEnvVersions(CodeEnvModel.AutomationUIEnv<TVersion> currentEnv, CodeEnvModel.AutomationUIEnv<TVersion> uiEnv, BiConsumer<TVersion, TVersion> modifyVersionConsumer) {
        HashMap currentVersions = Maps.newHashMap();
        HashMap uiVersions = Maps.newHashMap();
        if (currentEnv.currentVersion != null) {
            currentVersions.put("current", currentEnv.currentVersion);
        }
        if (currentEnv.noVersion != null) {
            currentVersions.put("no", currentEnv.noVersion);
        }
        if (currentEnv.versions != null) {
            for (CodeEnvModel.AbstractAutomationUIEnvVersion abstractAutomationUIEnvVersion : currentEnv.versions) {
                currentVersions.put(abstractAutomationUIEnvVersion.versionId, abstractAutomationUIEnvVersion);
            }
        }
        if (uiEnv.currentVersion != null) {
            uiVersions.put("current", uiEnv.currentVersion);
        }
        if (uiEnv.noVersion != null) {
            uiVersions.put("no", uiEnv.noVersion);
        }
        if (uiEnv.versions != null) {
            for (CodeEnvModel.AbstractAutomationUIEnvVersion abstractAutomationUIEnvVersion : uiEnv.versions) {
                uiVersions.put(abstractAutomationUIEnvVersion.versionId, abstractAutomationUIEnvVersion);
            }
        }
        if (!currentVersions.keySet().containsAll(uiVersions.keySet())) {
            throw new IllegalArgumentException("Trying to update non existing code env versions");
        }
        for (Map.Entry entry : currentVersions.entrySet()) {
            CodeEnvModel.AbstractAutomationUIEnvVersion currentVersion = (CodeEnvModel.AbstractAutomationUIEnvVersion)entry.getValue();
            CodeEnvModel.AbstractAutomationUIEnvVersion envVersion = (CodeEnvModel.AbstractAutomationUIEnvVersion)uiVersions.get(entry.getKey());
            if (envVersion == null) {
                logger.warn((Object)"Trying to update a version with empty, skipping");
                continue;
            }
            currentVersion.specCondaEnvironment = envVersion.specCondaEnvironment;
            currentVersion.specPackageList = envVersion.specPackageList;
            currentVersion.containerCacheBustingLocation = envVersion.containerCacheBustingLocation;
            currentVersion.dockerfileAtStart = envVersion.dockerfileAtStart;
            currentVersion.dockerfileBeforePackages = envVersion.dockerfileBeforePackages;
            currentVersion.dockerfileAfterCondaPackages = envVersion.dockerfileAfterCondaPackages;
            currentVersion.dockerfileAfterPackages = envVersion.dockerfileAfterPackages;
            currentVersion.dockerfileAtEnd = envVersion.dockerfileAtEnd;
            modifyVersionConsumer.accept(currentVersion, envVersion);
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-from-preset", "preset", "${preset}"})
    @RequestMapping(value={"/from-python-preset/{preset}"}, method={RequestMethod.POST})
    public void addFromPreset(HttpServletRequest req, HttpServletResponse resp, @PathVariable String preset, @RequestParam(defaultValue="true") boolean allowUpdate, @RequestParam(required=false) StandardPythonInterpreter interpreter, @RequestParam(required=false) String prefix) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCreateCodeEnvPrivilege(authCtx);
        }
        switch (ApplicationConfigurator.getNodeType()) {
            case DESIGN: {
                CodeEnvModel.DesignNewPythonEnvSpec spec = new CodeEnvModel.DesignNewPythonEnvSpec();
                spec.deploymentMode = CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED;
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeCodeEnvsService.handlePythonCodeEnvFromPreset(authCtx, spec, preset, allowUpdate, interpreter, prefix));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not available for nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-update", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/{envLang}/{envName}/packages"}, method={RequestMethod.POST})
    public void updatePackages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName, @RequestParam(defaultValue="false") boolean forceRebuildEnv, @RequestParam(required=false) String versionToUpdate) throws Exception {
        CodeEnvModel.AutomationUIEnv<?> containerConfBearingDesc;
        AuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, new Privileges.CodeEnvLevelPrivilegeType[]{Privileges.CodeEnvLevelPrivilegeType.UPDATE});
        }
        logger.info((Object)("Updating packages of " + envName + " of type " + String.valueOf(el)));
        CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
        updateSettings.forceRebuildEnv = forceRebuildEnv;
        FutureResponse fr = switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> {
                containerConfBearingDesc = this.getAutomationUIEnv(authCtx, el, envName);
                updateSettings.versionToUpdate = versionToUpdate;
                yield this.automationNodeCodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, el, envName, updateSettings);
            }
            case ApplicationConfigurator.DSSNodeType.DESIGN -> {
                containerConfBearingDesc = this.getDesignUIEnv(authCtx, el, envName);
                if (StringUtils.isNotBlank((String)versionToUpdate)) {
                    logger.warn((Object)"Ignoring version to update");
                }
                yield this.designNodeCodeEnvsService.startUpdateEnvAccordingToSpec(authCtx, el, envName, updateSettings);
            }
            default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
        };
        fr = this.futureService.waitForFinalResponse(fr);
        this.rebuildLinkedCodeStudioTemplate(authCtx, (CodeEnvModel.EnvUpdateResult)fr.result, (CodeEnvModel.ContainerConfBearingDesc)containerConfBearingDesc, el, envName);
        PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
    }

    private void rebuildLinkedCodeStudioTemplate(AuthCtx authCtx, CodeEnvModel.EnvUpdateResult result, CodeEnvModel.ContainerConfBearingDesc containerConfBearingDesc, CodeEnvModel.EnvLang el, String envName) throws UnauthorizedException {
        block11: {
            if (!containerConfBearingDesc.rebuildDependentCodeStudioTemplates.equals((Object)CodeEnvModel.ContainerConfBearingDesc.RebuildDependentCodeStudioTemplates.ALL)) {
                return;
            }
            if (!this.permissionsService.isAdmin(authCtx)) {
                String msg = "You are no authorized to list code env usages and thus can not built linked Code Studio templates.";
                logger.warn((Object)msg);
                result.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_NO_LIST_USAGES_PERMISSION, msg);
                return;
            }
            try {
                FutureResponse fr;
                List usages = this.codeEnvUsagesService.listUsages(new CodeEnvModel.UsedCodeEnvRef(el, envName), "__DKU_ANY_PROJECT__");
                ArrayList<String> templateIds = new ArrayList<String>();
                for (CodeEnvModel.CodeEnvUsage usage : usages) {
                    if (!usage.envUsage.equals((Object)CodeEnvModel.EnvUsage.CODE_STUDIO_TEMPLATE)) continue;
                    String templateId = usage.objectId;
                    templateIds.add(templateId);
                }
                if (templateIds.isEmpty()) break block11;
                try (Transaction t = this.transactionService.beginRead();){
                    fr = this.codeStudioTemplatesService.startMassBuild(authCtx, templateIds);
                }
                fr = this.futureService.waitForFinalResponse(fr);
                result.messages.mergeFrom(((CodeStudioTemplatesService.CodeStudioTemplateBuildResults)fr.result).messages);
            }
            catch (Exception e) {
                String msg = "Failed to build the Code Studio templates in which the Code Env " + envName + " is used.";
                logger.error((Object)msg, (Throwable)e);
                result.messages.withWarning((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CONTAINER_IMAGE_BUILD_FAILED, msg);
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-update", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/{envLang}/{envName}/images"}, method={RequestMethod.POST})
    public void updateImages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName, @RequestParam(required=false) String envVersion) throws Exception {
        AuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        logger.info((Object)("Rebuild image packages of " + envName + " of type " + String.valueOf(el)));
        CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
        updateSettings.versionToUpdate = envVersion;
        FutureResponse fr = switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> this.automationNodeCodeEnvsService.startRebuildImage(authCtx, el, envName, envVersion);
            case ApplicationConfigurator.DSSNodeType.DESIGN -> this.designNodeCodeEnvsService.startRebuildImage(authCtx, el, envName);
            default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
        };
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
    }

    @AuditedCall(value={"msgType", "admin-code-envs-update", "envLang", "${envLang}", "envName", "${envName}", "active", "${active}"})
    @RequestMapping(value={"/{envLang}/{envName}/jupyter"}, method={RequestMethod.POST})
    public void setJupyterSupport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName, @RequestParam boolean active) throws Exception {
        AuthCtx authCtx;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, el, envName, new Privileges.CodeEnvLevelPrivilegeType[]{Privileges.CodeEnvLevelPrivilegeType.UPDATE});
        }
        logger.info((Object)("Set jupyter support of " + envName + " of type " + String.valueOf(el) + " to " + active));
        FutureResponse fr = switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> {
                CodeEnvModel.AutomationEnvRootDef env = this.automationNodeCodeEnvsService.getEnvRootDef(el, envName);
                if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                    throw new IllegalArgumentException("Cannot alter jupyter support for versioned envs");
                }
                if (active) {
                    yield this.automationNodeCodeEnvsService.startInstallJupyterSupport(authCtx, el, envName, null);
                }
                yield this.automationNodeCodeEnvsService.startRemoveJupyterSupport(authCtx, el, envName, null);
            }
            case ApplicationConfigurator.DSSNodeType.DESIGN -> {
                if (active) {
                    yield this.designNodeCodeEnvsService.startInstallJupyterSupport(authCtx, el, envName);
                }
                yield this.designNodeCodeEnvsService.startRemoveJupyterSupport(authCtx, el, envName);
            }
            default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
        };
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
    }

    @AuditedCall(value={"msgType", "admin-code-envs-usages"})
    @RequestMapping(value={"/usages"}, method={RequestMethod.GET})
    public void getAllUsages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        logger.info((Object)"Get all code env usages");
        PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)this.codeEnvUsagesService.listUsages(null, new String[0]));
    }

    @AuditedCall(value={"msgType", "admin-code-envs-usages", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/{envLang}/{envName}/usages"}, method={RequestMethod.GET})
    public void getUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        logger.info((Object)("Get usages of " + envName + " of type " + String.valueOf(el)));
        PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)this.codeEnvUsagesService.listUsages(new CodeEnvModel.UsedCodeEnvRef(el, envName), new String[0]));
    }

    @AuditedCall(value={"msgType", "admin-code-envs-version", "envLang", "${envLang}", "envName", "${envName}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{envLang}/{envName}/{projectKey}/version"}, method={RequestMethod.GET})
    public void getEnvVersion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName, @PathVariable String projectKey) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            logger.info((Object)("Get env version of " + envName + " of type " + String.valueOf(el) + " for " + projectKey));
            FullCodeEnvRef ret = new FullCodeEnvRef();
            ret.name = envName;
            ret.lang = el;
            ret.projectKey = projectKey;
            if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
                CodeEnvModel.EnvVersionRef versionRef;
                String bundleId = null;
                if (CommonBundleUtils.hasActiveBundle((String)projectKey)) {
                    bundleId = CommonBundleUtils.getActiveBundleId((String)projectKey);
                }
                ret.bundleId = bundleId;
                CodeEnvModel.AutomationEnvRootDef env = this.automationNodeCodeEnvsService.getEnvRootDef(el, envName);
                if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED && StringUtils.isNotBlank((String)bundleId) && (versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink((CodeEnvModel.EnvLang)el, (String)envName, (String)projectKey, (String)bundleId)) != null) {
                    ret.version = versionRef.envVersion;
                }
            }
            PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-log", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/{envLang}/{envName}/logs"}, method={RequestMethod.GET})
    public void listLogs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeCodeEnvsService.listLogs(el, envName));
                break;
            }
            case DESIGN: {
                PublicAPICodeEnvsController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeCodeEnvsService.listLogs(el, envName));
                break;
            }
            default: {
                throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
            }
        }
    }

    @AuditedCall(value={"msgType", "admin-code-envs-log", "envLang", "${envLang}", "envName", "${envName}"})
    @RequestMapping(value={"/{envLang}/{envName}/logs/{logName:.+}"}, method={RequestMethod.GET})
    public void getLog(HttpServletRequest req, HttpServletResponse resp, @PathVariable String envLang, @PathVariable String envName, @PathVariable String logName) throws Exception {
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf((String)envLang.toUpperCase());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        File log = switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> this.automationNodeCodeEnvsService.getLogFile(el, envName, logName);
            case ApplicationConfigurator.DSSNodeType.DESIGN -> this.designNodeCodeEnvsService.getLogFile(el, envName, logName);
            default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf(ApplicationConfigurator.getNodeType()));
        };
        if (log == null) {
            throw new IOException("No log " + logName);
        }
        this.writeFile(resp, log, "text/plain");
    }

    private CodeEnvModel.AbstractDesignUIEnv<?> getDesignUIEnv(AuthCtx authCtx, CodeEnvModel.EnvLang el, String envName) throws IOException, DKUSecurityException {
        CodeEnvModel.AbstractDesignUIEnv designEnv = this.designNodeCodeEnvsService.getEnvForUI(el, envName, true);
        try (Transaction t = this.transactionService.beginRead();){
            designEnv.canManageUsersCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
            designEnv.canUpdateCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        return designEnv;
    }

    private CodeEnvModel.AutomationUIEnv<?> getAutomationUIEnv(AuthCtx authCtx, CodeEnvModel.EnvLang el, String envName) throws Exception {
        CodeEnvModel.AutomationUIEnv automationEnv = this.automationNodeCodeEnvsService.getEnvForUI(el, envName, true);
        try (Transaction t = this.transactionService.beginRead();){
            automationEnv.canManageUsersCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
            automationEnv.canUpdateCodeEnv = this.permissionsService.hasCodeEnvPrivilege(authCtx, el, envName, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        }
        return automationEnv;
    }

    public static class FullCodeEnvRef {
        public CodeEnvModel.EnvLang lang;
        public String name;
        public String version;
        public String projectKey;
        public String bundleId;
    }
}

