/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.agents.tools.PythonAgentToolServerPool;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServerPool;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.docextraction.DocExtractionKernelPool;
import com.dataiku.dip.eda.compute.ComputeService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.input.BindableExportInput;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.llm.custom.CustomPythonLLMKernelPool;
import com.dataiku.dip.llm.evaluation.TestCustomMetricKernelPool;
import com.dataiku.dip.llm.governance.custom.PythonGuardrailServerPool;
import com.dataiku.dip.llm.langchain.PythonLLMServerKernelPool;
import com.dataiku.dip.llm.local.HuggingFaceKernelPool;
import com.dataiku.dip.llm.online.LLMCostLimitingCountersRepository;
import com.dataiku.dip.llm.pii.PIIKernelPool;
import com.dataiku.dip.llm.retrieval.RAGKernelPool;
import com.dataiku.dip.maintainance.GenericUsageSummaryReportsService;
import com.dataiku.dip.mec.drift.DriftService;
import com.dataiku.dip.projects.TutorialsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKey;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.BackendAPITicketService;
import com.dataiku.dip.security.trust.FingerprintService;
import com.dataiku.dip.server.SlowAndFailInterceptor;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.connections.ConnectionsIndexingService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.WebSocketController;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.DebugClearShakerTableCache;
import com.dataiku.dip.server.notifications.backend.DebugForceIndexAllEvent;
import com.dataiku.dip.server.notifications.backend.DebugForceIndexProjectEvent;
import com.dataiku.dip.server.notifications.backend.ScenarioStateChangeEvent;
import com.dataiku.dip.server.notifications.digest.NotificationsDigestsService;
import com.dataiku.dip.server.notifications.offlinequeues.UserOfflineQueueService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.catalog.internal.InternalDataCatalogService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.transactions.DebugTransactionRegistry;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DKUDebugUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.NamedRWLock;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dss.shadelib.com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DebugController
extends DIPInternalControllerBase {
    private static DKULogger logger = DKULogger.getLogger((String)"debugging");
    @Autowired
    private MetaAuthService metaAuthService;
    @Autowired
    private UIAuthService uiAuthService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private ScenarioReportsService scenarioReportsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private PIIKernelPool piiKernelPool;
    @Autowired
    private HuggingFaceKernelPool hfKernelPool;
    @Autowired
    private RAGKernelPool ragKernelPool;
    @Autowired
    private TestCustomMetricKernelPool testCustomMetricKernelPool;
    @Autowired
    private DocExtractionKernelPool docExtractionKernelPool;
    @Autowired
    private VectorStoreQueryToolServerPool vectorStoreQueryToolServerPool;
    @Autowired
    private PythonAgentToolServerPool pythonAgentToolServerPool;
    @Autowired
    private PythonGuardrailServerPool pythonGuardrailServerPool;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private UserOfflineQueueService userOfflineQueueService;
    @Autowired
    private NotificationsDigestsService notificationsDigestsService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private ScenariosTriggerService scenariosTriggerService;
    @Autowired
    private GenericUsageSummaryReportsService genericUsageSummaryReportsService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private ComputeService computeService;
    @Autowired
    private FingerprintService fingerprintService;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private DriftService driftService;
    @Autowired
    private TutorialsService tutorialsService;
    @Autowired
    private PythonLLMServerKernelPool pythonLLMServerKernelPool;
    @Autowired
    private LLMCostLimitingCountersRepository countersRepository;
    @Autowired
    private CustomPythonLLMKernelPool customPythonLLMKernelPool;

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/kill-backend"})
    public void killBackend(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        System.err.println("********** Exiting on forced request");
        System.exit(1);
    }

    @AuditedCall(value={"msgType", "slow-transaction-simulate"})
    @RequestMapping(value={"/api/debugging/slow-transaction"})
    public void slowTransaction(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="20000") int durationMs, @RequestParam(defaultValue="false") boolean rw) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        if (rw) {
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                Thread.sleep(durationMs);
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            Thread.sleep(durationMs);
        }
        resp.setStatus(200);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-backend-stacks"})
    public void getBackendStacks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        DKUDebugUtils.printAllStacks((Writer)resp.getWriter());
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/restart-all-html-backends"})
    public void restartHtmlBackends(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Collection webApps;
        AuthCtx authCtx = null;
        WebAppsService webAppsService = (WebAppsService)SpringUtils.getBean(WebAppsService.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            this.uiAuthService.failIfNotAdminNoXSRF(req);
            webApps = webAppsService.listRegisteredBackends();
        }
        webAppsService.restartBackends_NT(webApps, authCtx);
    }

    @AuditedCall(value={"msgType", "fake-slow-code"})
    @RequestMapping(value={"/api/debugging/fake-slow-code"})
    public void markSlowCodeInTxn(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.uiAuthService.failIfNotAdminNoXSRF(req);
            PerfUtils.markSlowCode();
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/run-scenario-triggers"})
    public void runScenarioTriggers(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            ((ScenariosTriggerService)SpringUtils.getBean(ScenariosTriggerService.class)).forceTriggerThreadExecution();
            resp.getWriter().write("Triggers are running; scenarios triggered will execute without delay.");
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-transactions-state"})
    public void dumpTransactionsState(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting transactions state dump");
        DebugTransactionRegistry dtr = (DebugTransactionRegistry)SpringUtils.getBean(DebugTransactionRegistry.class);
        String dump = dtr.getTransactionStateDump();
        logger.info((Object)dump);
        resp.getWriter().write("Currently running transactions\n");
        resp.getWriter().write(dump);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/debugging/slow-fail"})
    public void slowFail(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="fail", defaultValue="false", required=false) boolean fail, @RequestParam(value="delay", defaultValue="0", required=false) int delay) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        SlowAndFailInterceptor.callsDelay = delay;
        SlowAndFailInterceptor.failCalls = fail;
        if (fail) {
            resp.getWriter().write("From now on, all backend calls will return an HTTP 503 error.");
        } else if (delay > 0) {
            resp.getWriter().write("From now on, all backend calls will be slower. Delay: " + delay + " msec");
        } else {
            resp.getWriter().write("From now on, all backend calls will behave as normal (no additional delay or failure).");
        }
        resp.getWriter().flush();
    }

    @RequestMapping(value={"/api/debugging/read-and-write-slow-serialization"})
    @ResponseBody
    public SlowClass testSlowReadWrite(@RequestParam(defaultValue="{}") SlowClass input, HttpServletRequest req) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req, false);
        logger.info((Object)"Testing slow read write");
        return new SlowClass();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-sessions"})
    public void dumpTrackingSessions(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting tracking sessions dump");
        TrackingService svc = (TrackingService)SpringUtils.getBean(TrackingService.class);
        WebSocketController wsc = WebSocketController.getInstance();
        ArrayList list = svc.listSessions();
        resp.getWriter().write("Active websockets:  " + wsc.getNbActiveSockets() + "\n");
        resp.getWriter().write("\n");
        Collection authCtxs = wsc.getCurrentlyLoggedInUsers(true);
        resp.getWriter().write("Currently connected users (" + authCtxs.size() + ")\n");
        resp.getWriter().write("--------------------------------\n");
        for (AuthCtx authCtx : authCtxs) {
            resp.getWriter().write(authCtx.getIdentifier() + "\n");
        }
        resp.getWriter().write("\n");
        resp.getWriter().write("Currently active tracking sessions (" + list.size() + ")\n");
        resp.getWriter().write("--------------------------------------------\n");
        for (TrackingService.TrackingSession ts : svc.listSessions()) {
            Map stateParams = ts.getStateParams();
            String projectKey = stateParams == null ? "null" : String.valueOf(stateParams.get("projectKey"));
            String dbg = String.format("Session id=%s\tuser=%s\tproject=%s\tidle=%s\tlastRefresh=%s\tstate=%s\tstateParams=%s", ts.getSessionId(), ts.getUser().login, projectKey, ts.isIdle(), DKUDateUtils.isoFormatLocal((long)ts.getLastRefreshed()), ts.getState(), JSON.json((Object)stateParams));
            logger.info((Object)dbg);
            resp.getWriter().write(dbg + "\n");
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-llm-mesh"})
    @ResponseBody
    public LLMMeshDump dumpLLMMesh(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean full) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, false);
        LLMMeshDump dump = new LLMMeshDump();
        dump.piiPool = this.piiKernelPool.dump(full);
        dump.hfPool = this.hfKernelPool.dump(full);
        dump.ragPool = this.ragKernelPool.dump(full);
        dump.testCustomMetricPool = this.testCustomMetricKernelPool.dump(full);
        dump.docExtractionKernelPool = this.docExtractionKernelPool.dump(full);
        dump.pythonLLMPool = this.pythonLLMServerKernelPool.dump(full);
        dump.vectorStoreQueryToolsPool = this.vectorStoreQueryToolServerPool.dump(full);
        dump.pythonAgentToolsPool = this.pythonAgentToolServerPool.dump(full);
        dump.pythonGuardrailsPool = this.pythonGuardrailServerPool.dump(full);
        dump.customPythonLLMPool = this.customPythonLLMKernelPool.dump(full);
        return dump;
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-llm-cost-limit-counters"})
    @ResponseBody
    public Map<String, LLMCostLimitingCountersRepository.AggregatedDataWithDetails> dumpLLMCostLimitCounters(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean full) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, false);
        return this.countersRepository.getAllAggregatedData(true);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/clear-llm-cost-limit-counters"})
    public void clearLLMCostLimitCounters(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.countersRepository.clearAllCounters();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/kill-llm-kernels"})
    public void killLLMKernels(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.piiKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.hfKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.ragKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.testCustomMetricKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.docExtractionKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.pythonLLMServerKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.vectorStoreQueryToolServerPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.pythonAgentToolServerPool.killAllKernels(KernelPool.DeathReason.DEBUG);
        this.customPythonLLMKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/kill-llm-requests"})
    @ResponseBody
    public void killLLMRequests(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.piiKernelPool.killAllRequests();
        this.hfKernelPool.killAllRequests();
        this.ragKernelPool.killAllRequests();
        this.testCustomMetricKernelPool.killAllRequests();
        this.docExtractionKernelPool.killAllRequests();
        this.pythonLLMServerKernelPool.killAllRequests();
        this.vectorStoreQueryToolServerPool.killAllRequests();
        this.pythonAgentToolServerPool.killAllRequests();
        this.customPythonLLMKernelPool.killAllRequests();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/generate-logs"})
    @ResponseBody
    public Long generateLotsOfLogs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"Starting log dump...");
        int nbThreads = 100;
        int nbLogsByThread = 500;
        int maxLogDelayMs = 20;
        ExecutorService executor = Executors.newFixedThreadPool(nbThreads);
        Stopwatch counter = Stopwatch.createStarted();
        for (int t = 0; t < nbThreads; ++t) {
            executor.submit(() -> {
                try {
                    for (int i = 1; i <= nbLogsByThread; ++i) {
                        Thread.sleep(ThreadLocalRandom.current().nextInt(0, maxLogDelayMs));
                        logger.debug((Object)("Mass generating logs " + i + "/" + nbLogsByThread));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        logger.info((Object)("Log dump took " + String.valueOf(counter.elapsed())));
        return counter.elapsed(TimeUnit.SECONDS);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/generate-audit"})
    @ResponseBody
    public Long generateLotsOfAudit(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="40") int nbThreads, @RequestParam(defaultValue="5000") int nbEventsPerThread, @RequestParam(defaultValue="2") int maxDelayBetweenEvents) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)("Starting audit flood with " + nbThreads + " threads"));
        ExecutorService executor = Executors.newFixedThreadPool(nbThreads);
        Stopwatch counter = Stopwatch.createStarted();
        AuditTrailService ats = (AuditTrailService)SpringUtils.getBean(AuditTrailService.class);
        int t = 0;
        while (t < nbThreads) {
            int tf = t++;
            executor.submit(() -> {
                logger.info((Object)("Thread " + tf + " starting to emit audit"));
                try {
                    for (int i = 1; i <= nbEventsPerThread; ++i) {
                        if (maxDelayBetweenEvents > 0) {
                            Thread.sleep(ThreadLocalRandom.current().nextInt(0, maxDelayBetweenEvents));
                        }
                        if (i % 2 == 0) {
                            ats.generic("fake-flooding-audit").with("projectKey", "A project").with("authCtx", "some-authctx").emit();
                            continue;
                        }
                        ats.emittable("allcalls", null).with("msgType", "fake-flooding-audit").with("projectKey", "A project").with("authCtx", "some-authctx").emit();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.info((Object)("Thread " + tf + " done emitting audit"));
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        logger.info((Object)("Audit generation took " + counter.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return counter.elapsed(TimeUnit.SECONDS);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-named-locks"})
    public void dumpNamedLocks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        NamedLock.LockInfo info;
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting named locks dump");
        Map map = NamedLock.dumpAcquiredLocksInfo();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            info = (NamedLock.LockInfo)entry.getValue();
            Object x = "";
            if (info.isLocked) {
                x = "[LOCK] " + name;
                Thread t = info.owner;
                x = (String)x + " owner=" + (t == null ? null : t.getName() + "(" + t.getId() + ")");
                if (t != null) {
                    x = (String)x + "\n";
                    StackTraceElement[] stackTraceElementArray = t.getStackTrace();
                    int n = stackTraceElementArray.length;
                    for (int i = 0; i < n; ++i) {
                        StackTraceElement elt = stackTraceElementArray[i];
                        x = (String)x + "\t" + elt.toString() + "\n";
                    }
                }
            } else {
                x = (String)x + "[FREE] " + name;
            }
            resp.getWriter().write((String)x + "\n");
            logger.info(x);
        }
        map = NamedRWLock.dumpAcquiredLocksInfo();
        for (Map.Entry entry : map.entrySet()) {
            String x = "[RWLOCK] " + (String)entry.getKey();
            info = (NamedRWLock.RWLockInfo)entry.getValue();
            Thread t = info.owner;
            x = x + " writeOwner=" + (t == null ? null : t.getName() + "(" + t.getId() + ")");
            x = x + " readersCount=" + info.readLockCount;
            x = x + " queueLength=" + info.queueLength;
            if (t != null) {
                x = x + "\n";
                for (StackTraceElement elt : t.getStackTrace()) {
                    x = x + "\t" + elt.toString() + "\n";
                }
            } else {
                x = x + " (FREE)";
            }
            resp.getWriter().write(x + "\n");
            logger.info((Object)x);
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-metrics"})
    public void dumpMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean gc) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting metrics dump");
        DKUDebugUtils.printMetrics((OutputStream)resp.getOutputStream(), (boolean)gc);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/clear-clearable-metrics"})
    public void clearClearableMetrics(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: clearing metrics");
        DSSMetrics.clearAllTimersAndMeters();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-file-cache-inspection"})
    public void dumpFileCacheInspection(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting file cache inspection");
        this.transactionService.getCache().inspectionData((Appendable)resp.getWriter());
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-file-cache-item"})
    public void dumpFileCacheInspection(HttpServletRequest req, HttpServletResponse resp, @RequestParam String path) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting file cache inspection");
        resp.getWriter().write(this.transactionService.getCache().fullDumpItem(path));
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-api-tickets"})
    public void dumpTickets(HttpServletRequest req, HttpServletResponse resp) throws IOException, DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting API tickets dump");
        BackendAPITicketService ticketService = (BackendAPITicketService)SpringUtils.getBean(BackendAPITicketService.class);
        resp.getWriter().write("Id\tCreation\tAuthCtx\n");
        for (APITicketService.Ticket ti : ticketService.getAllActiveTickets()) {
            resp.getWriter().write(ti.id);
            resp.getWriter().write("\t");
            resp.getWriter().write(DKUDateUtils.isoFormatLocal((long)ti.creationTime));
            resp.getWriter().write("\t");
            resp.getWriter().write(ti.getOriginalUser().toString());
            resp.getWriter().write("\n");
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/run-fake-scenario"})
    public void fakeScenarioRun(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String date, @RequestParam String outcome) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.uiAuthService.getMandatoryUser(req);
            this.scenariosService.fakeRun(user, projectKey, scenarioId, date, outcome);
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/clear-scenario-report-caches"})
    public void clearScenarioReportsCaches(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        try (Transaction t = this.transactionService.beginRead();){
            this.scenarioReportsService.invalidateCachedReports();
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/run-fake-future"})
    public void fakeFuture(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String payloadClassName, @RequestParam String payloadMethodName, @RequestParam boolean randomUser) throws Exception {
        FuturePayload payload;
        DSSAuthCtx authCtx;
        Random random = new Random();
        try (Transaction t = this.transactionService.beginRead();){
            this.uiAuthService.failIfNotAdmin(req);
            authCtx = (DSSAuthCtx)this.uiAuthService.getMandatoryUser(req);
            if (randomUser) {
                List users = this.usersService.listUsersInternalUnsafeEnabledOnly();
                int picked = random.nextInt(users.size());
                authCtx = DSSAuthCtx.forUserLogin((UsersDAO.User)((UsersDAO.User)users.get(picked)));
            }
            Class<?> payloadClass = Class.forName(payloadClassName);
            Method payloadMethod = null;
            for (Method method : payloadClass.getDeclaredMethods()) {
                if (!method.getName().equals(payloadMethodName)) continue;
                payloadMethod = method;
                break;
            }
            ArrayList params = Lists.newArrayList();
            String[] parameterNames = null;
            try {
                StandardReflectionParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();
                parameterNames = discoverer.getParameterNames(payloadMethod);
            }
            catch (Throwable e) {
                logger.info((Object)"Cannot get method parameter names", e);
            }
            assert (payloadMethod != null);
            Class<?>[] parameterTypes = payloadMethod.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<FutureThread> parameterType = parameterTypes[i];
                String parameterName = parameterNames != null ? parameterNames[i] : "";
                logger.info((Object)("param " + parameterName + " of type " + parameterType.getCanonicalName()));
                Object param = null;
                if (parameterType == Dataset.class) {
                    datasets = this.datasetsDAO.listUnsafe(projectKey);
                    if (datasets.size() > 0) {
                        param = Dataset.fromSerialized((SerializedDataset)((SerializedDataset)datasets.get(random.nextInt(datasets.size()))));
                    }
                } else if (parameterType.isAssignableFrom(FutureThread.class)) {
                    FuturePayload fakePayload = new FuturePayload();
                    fakePayload.displayName = "fake in fake";
                    param = new FakeFutureThread(authCtx, fakePayload);
                } else if (parameterType == ExportInput.class) {
                    datasets = this.datasetsDAO.listUnsafe(projectKey);
                    param = datasets.size() > 0 ? new ExportDataset((AuthCtx)authCtx, (SerializedDataset)datasets.get(random.nextInt(datasets.size()))) : new BindableExportInput("bin", 100L);
                } else if (parameterType == SQLNotebookQuery.class) {
                    SQLNotebookQuery query = new SQLNotebookQuery();
                    query.mode = SQLNotebookQuery.QueryMode.SQL;
                    param = query;
                } else if (parameterType == String.class) {
                    if ("projectKey".equals(parameterName)) {
                        param = projectKey;
                    } else if ("notebookName".equals(parameterName)) {
                        param = "a notebook";
                    } else if ("notebookId".equals(parameterName)) {
                        List notebooks = this.sqlNotebooksDAO.listUnsafe(projectKey);
                        if (notebooks.size() > 0) {
                            param = ((SQLNotebook)notebooks.get((int)random.nextInt((int)notebooks.size()))).id;
                        }
                    } else if ("exportId".equals(parameterName)) {
                        param = "an id of an export";
                    }
                }
                params.add(param);
            }
            payload = (FuturePayload)payloadMethod.invoke(null, params.toArray(new Object[0]));
        }
        FakeFutureThread ft = new FakeFutureThread(authCtx, payload);
        FutureResponse fr = this.futureService.runFuture((FutureThreadBase)ft, 100L, (TypeToken)new TypeToken<FutureResponse<String>>(){});
        DebugController.writeJSON((HttpServletResponse)resp, (Object)fr);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/send-offline-queues"})
    public void sendOfflineQueues(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.userOfflineQueueService.sendAll();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/send-digests"})
    public void sendDigests(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.notificationsDigestsService.sendAll();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/build-usage-summary-reports"})
    public void buildUsageSummaryReports(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.genericUsageSummaryReportsService.saveAll();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/flood-websocket"})
    public void floodWebsocket(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        for (int i = 0; i < 1000; ++i) {
            this.pubSubService.publish((DSSEvent)new ScenarioStateChangeEvent("fakeproject", "fakeScenario", "fakeRun", ScenarioStateChangeEvent.State.DONE, "fakeUser", "fakeScenarioName"));
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/invalidate-flow-cache"})
    public void invalidateFlowCache(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        ((FlowGraphService)SpringUtils.getBean(FlowGraphService.class)).invalidateCache();
    }

    @RequestMapping(value={"/api/debugging/invalidate-eda-caches"})
    @ResponseBody
    public void clearResultsCache(HttpServletRequest req, HttpServletResponse resp) throws IOException, DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.computeService.clearCaches();
    }

    @RequestMapping(value={"/api/debugging/invalidate-fingerprint-cache"})
    @ResponseBody
    public void clearFingerprintCache(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.fingerprintService.clearCache();
    }

    @RequestMapping(value={"/api/debugging/invalidate-drift-caches"})
    @ResponseBody
    public void clearDriftCaches(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.driftService.clearCaches();
    }

    @RequestMapping(value={"/api/debugging/invalidate-in-memory-keys"})
    @ResponseBody
    public void clearInMemoryKeys(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.publicAPIKeysService.invalidateInMemoryAPIKeys();
    }

    @RequestMapping(value={"/api/debugging/list-in-memory-keys"})
    @ResponseBody
    public List<GlobalScopePublicAPIKey> listInMemoryKeys(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        return this.publicAPIKeysService.listInMemoryAPIKeys();
    }

    @RequestMapping(value={"/api/debugging/put-in-memory-key-in-the-past"})
    @ResponseBody
    public void putInMemoryKeyInThePast(HttpServletRequest req, HttpServletResponse resp, @RequestParam String keyId) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.publicAPIKeysService.putInMemoryAPIKeyInThePast(keyId);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/get-flow-global-graph"})
    public void getFlowGlobalGraph(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            ((FlowGraphService)SpringUtils.getBean(FlowGraphService.class)).getGlobalGraph(true);
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/get-flow-global-graph-unsafe"})
    public void getFlowGlobalGraphUnsafe(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            ((FlowGraphService)SpringUtils.getBean(FlowGraphService.class)).getGlobalGraphUnsafe(true);
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/get-flow-project-graph"})
    public void getFlowProjectGraph(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            ((FlowGraphService)SpringUtils.getBean(FlowGraphService.class)).getProjectGraph(projectKey, true);
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/get-flow-project-graph-unsafe"})
    public void getFlowProjectGraphUnsafe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            ((FlowGraphService)SpringUtils.getBean(FlowGraphService.class)).getProjectGraphUnsafe(projectKey);
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/datacatalog-index-all"})
    public void dataCatalogIndexAll(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"Queuing index all");
        ((InternalDataCatalogService)SpringUtils.getBean(InternalDataCatalogService.class)).debugOnlyGetIndexerQueue().add((BackendEvent)new DebugForceIndexAllEvent());
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/datacatalog-index-project"})
    public void dataCatalogIndexAll(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"Queuing index project");
        DebugForceIndexProjectEvent evt = new DebugForceIndexProjectEvent();
        evt.projectKey = projectKey;
        ((InternalDataCatalogService)SpringUtils.getBean(InternalDataCatalogService.class)).debugOnlyGetIndexerQueue().add((BackendEvent)evt);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/datacatalog-index-all-external"})
    public void dataCatalogIndexAllExternal(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String action) throws Exception {
        if (action == null || !action.equals("INDEX") && !action.equals("SCAN")) {
            resp.setStatus(400);
            resp.getWriter().write("Missing parameter action: [INDEX, SCAN]");
        } else {
            this.uiAuthService.failIfNotAdmin(req);
            AuthCtx user = this.uiAuthService.getMandatoryUser(req);
            ConnectionsIndexingService indexingService = (ConnectionsIndexingService)SpringUtils.getBean(ConnectionsIndexingService.class);
            ConnectionsIndexingService.ListIndexableConnectionsResponse connections = indexingService.getIndexableConnections_NT(user);
            FutureResponse<InfoMessage.InfoMessages> futureResponse = null;
            Set<String> selectedConnections = null;
            if (action.equals("SCAN")) {
                selectedConnections = connections.scannableConnections;
                futureResponse = indexingService.startScanAndIndex(selectedConnections, user);
            } else if (action.equals("INDEX")) {
                selectedConnections = connections.indexableConnections;
                futureResponse = indexingService.startIndex(selectedConnections, user);
            }
            if (futureResponse != null && selectedConnections != null) {
                this.futureService.waitForFinalResponse(futureResponse.jobId);
                Map all = ((ConnectionMetadataDAO)SpringUtils.getBean(ConnectionMetadataDAO.class)).getAll();
                ArrayList<ConnectionMetadataDAO.ConnectionMetadata> result = new ArrayList<ConnectionMetadataDAO.ConnectionMetadata>();
                for (String selectedConnection : selectedConnections) {
                    result.add((ConnectionMetadataDAO.ConnectionMetadata)all.get(selectedConnection));
                }
                DebugController.writeJSON((HttpServletResponse)resp, result);
            }
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/clear-shaker-table-cache"})
    public void clearShakerTableCache(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"Clearing table cache");
        ((PubSubService)SpringUtils.getBean(PubSubService.class)).publish((DSSEvent)new DebugClearShakerTableCache());
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/set-global-log-level"})
    public void setGlobalLogLevel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String level) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        Logger.getRootLogger().setLevel(Level.toLevel((String)level));
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/set-logger-log-level"})
    public void setLoggerLogLevel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String logger, @RequestParam String level) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        Logger.getLogger((String)logger).setLevel(Level.toLevel((String)level));
    }

    @AuditedCall(value={"msgType", "scenario-debug"})
    @RequestMapping(value={"/api/debugging/get-trigger-queueing-info"})
    public void getTriggerQueueingInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        DebugController.writeJSON((HttpServletResponse)resp, (Object)this.scenariosTriggerService.getTriggerQueueingInfo());
    }

    @AuditedCall(value={"msgType", "resync-project-folders"})
    @RequestMapping(value={"/api/debugging/resync-project-folders"})
    public void resyncProjectFolders(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.projectFoldersService.cleanUpProjectFolders_NT(false);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/reloadTutorials"})
    public void reloadTutorials(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.tutorialsService.fetchNow();
    }

    static {
        JSON.registerFactory((TypeAdapterFactory)new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getType() != SlowClass.class) {
                    return null;
                }
                final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, typeToken);
                return new TypeAdapter<T>(){

                    public void write(JsonWriter jsonWriter, T t) throws IOException {
                        logger.info((Object)"Will write SlowClass, starting to sleep");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        logger.info((Object)"Done writing SlowClass");
                        delegate.write(jsonWriter, t);
                    }

                    public T read(JsonReader jsonReader) throws IOException {
                        logger.info((Object)"Will read SlowClass, starting to sleep");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        logger.info((Object)"Done reading SlowClass");
                        return delegate.read(jsonReader);
                    }
                };
            }
        });
    }

    public static class SlowClass {
        int x = 4;
    }

    public static class LLMMeshDump {
        public KernelPool.PoolDump piiPool;
        public KernelPool.PoolDump hfPool;
        public KernelPool.PoolDump ragPool;
        public KernelPool.PoolDump testCustomMetricPool;
        public KernelPool.PoolDump docExtractionKernelPool;
        public KernelPool.PoolDump pythonLLMPool;
        public KernelPool.PoolDump vectorStoreQueryToolsPool;
        public KernelPool.PoolDump pythonAgentToolsPool;
        public KernelPool.PoolDump pythonGuardrailsPool;
        public KernelPool.PoolDump customPythonLLMPool;
    }

    private static class FakeFutureThread
    extends FutureThread<String> {
        private final FuturePayload payload;

        FakeFutureThread(DSSAuthCtx authCtx, FuturePayload payload) {
            super(authCtx);
            this.payload = payload;
        }

        public FuturePayload getPayload() {
            return this.payload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public String getResult() {
            return "done";
        }

        public void execute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState state0 = FutureProgress.pushAutoCloseableState((String)"level 0", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.FILES);){
                for (int i0 = 0; i0 < 5; ++i0) {
                    try (FutureProgress.AutocloseableFutureProgressState state1 = FutureProgress.pushAutoCloseableState((String)"level 1", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS);){
                        for (int i1 = 0; i1 < 5; ++i1) {
                            try (FutureProgress.AutocloseableFutureProgressState state2 = FutureProgress.pushAutoCloseableState((String)"level 2", (double)5000.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE);){
                                for (int i2 = 0; i2 < 5; ++i2) {
                                    try (FutureProgress.AutocloseableFutureProgressState state3 = FutureProgress.pushAutoCloseableState((String)"level 3", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                                        for (int i3 = 0; i3 < 5; ++i3) {
                                            Thread.sleep(50L);
                                            state3.increment(1.0);
                                        }
                                    }
                                    state2.increment(1000.0);
                                }
                            }
                            state1.increment(1.0);
                        }
                    }
                    state0.increment(1.0);
                }
            }
        }
    }
}

