/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.LuceneInitIndexEvent;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.CustomMultiFieldQueryParser;
import com.dataiku.dip.server.services.catalog.IndexNotBuiltException;
import com.dataiku.dip.server.services.catalog.IndexingDisabledException;
import com.dataiku.dip.server.services.catalog.LuceneConfiguration;
import com.dataiku.dip.server.services.catalog.LuceneHelpers;
import com.dataiku.dip.server.services.catalog.LuceneHighlighter;
import com.dataiku.dip.server.services.catalog.LuceneIndexException;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneQueryWrapper;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dip.server.services.catalog.TotalHitsCount;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetResult;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.Facets;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.LabelAndValue;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.QueryParser;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BoostQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Collector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchAllDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreDoc;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopDocs;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSearchService
implements DSSEventListener<BackendEvent> {
    public static final int INITIAL_DELAY = DKUApp.getParams().getIntParam("dku.catalog.initialDelay", Integer.valueOf(5000));
    public static final int MAX_NUMBER_OF_FACETS = 1000;
    public static final String FACET_PREFIX = "facet_";
    public static final Pattern UNDERSCORE_SEPARATOR = Pattern.compile("_+");
    public static final Pattern CAMELCASE_SEPARATOR = Pattern.compile("((?<=\\p{Ll}))((?=\\p{Lu}))");
    public static final Pattern SIMPLE_WORD = Pattern.compile("(\\s|^)(?!AND\\b|OR\\b)([^\\s]+)");
    public static final Map<IndexableType, List<String>> FACETS_FOR_TYPE = new ImmutableMap.Builder().put((Object)IndexableType.ALL, Arrays.asList("_type", "projectKey.raw", "tag.raw", "type_raw", "user", "connection.raw", "catalog.raw", "schema.raw", "partitioned")).put((Object)IndexableType.DATASET, Arrays.asList("_type", "projectKey.raw", "tag.raw", "type_raw", "partitioned", "dataSteward", "isInDataCollection")).put((Object)IndexableType.FEATURE_GROUP, Arrays.asList("_type", "projectKey.raw", "tag.raw", "user", "partitioned", "isQuicklyShareable")).put((Object)IndexableType.FEATURE, Arrays.asList("_type", "projectKey.raw", "tag.raw", "user", "meaning", "isQuicklyShareable")).put((Object)IndexableType.PROJECT, Arrays.asList("_type", "tag.raw", "projectKey.raw")).put((Object)IndexableType.NOTEBOOK, Arrays.asList("_type", "tag.raw", "projectKey.raw", "type_raw", "language", "dataset")).put((Object)IndexableType.RECIPE, Arrays.asList("_type", "tag.raw", "projectKey.raw", "type_raw")).put((Object)IndexableType.ANALYSIS, Arrays.asList("_type", "tag.raw", "projectKey.raw")).put((Object)IndexableType.INSIGHT, Arrays.asList("_type", "projectKey.raw", "type_raw", "owner")).put((Object)IndexableType.WEB_APP, (Object)Lists.newArrayList((Object[])new String[]{"_type", "projectKey.raw"})).put((Object)IndexableType.CODE_STUDIO, (Object)Lists.newArrayList((Object[])new String[]{"_type", "projectKey.raw"})).put((Object)IndexableType.REPORT, (Object)Lists.newArrayList((Object[])new String[]{"_type", "projectKey.raw"})).put((Object)IndexableType.DASHBOARD, (Object)Lists.newArrayList((Object[])new String[]{"_type", "projectKey.raw", "owner"})).put((Object)IndexableType.SAVED_MODEL, Arrays.asList("_type", "tag.raw", "projectKey.raw", "type_raw")).put((Object)IndexableType.MODEL_EVALUATION_STORE, Arrays.asList("_type", "tag.raw", "projectKey.raw", "type_raw")).put((Object)IndexableType.MODEL_COMPARISON, Arrays.asList("_type", "tag.raw", "projectKey.raw", "type_raw")).put((Object)IndexableType.MANAGED_FOLDER, Arrays.asList("_type", "tag.raw", "projectKey.raw", "partitioned")).put((Object)IndexableType.SCENARIO, Arrays.asList("_type", "tag.raw", "projectKey.raw")).put((Object)IndexableType.ARTICLE, Arrays.asList("_type", "tag.raw", "projectKey.raw")).put((Object)IndexableType.STATISTICS_WORKSHEET, Arrays.asList("_type", "projectKey.raw")).put((Object)IndexableType.DISCUSSION, Arrays.asList("_type", "projectKey.raw", "objectType", "workspaceKey", "closed")).put((Object)IndexableType.COLUMN, Arrays.asList("_type", "projectKey.raw", "tag.raw", "dataset", "dataset.raw", "storedAs")).put((Object)IndexableType.TABLE, Arrays.asList("_type", "connection.raw", "catalog.raw", "schema.raw", "partitioned", "tag.raw")).put((Object)IndexableType.MEANING, (Object)Lists.newArrayList((Object[])new String[]{"udm_type"})).put((Object)IndexableType.FLOW_ZONE, Arrays.asList("_type", "projectKey.raw")).put((Object)IndexableType.LABELING_TASK, Arrays.asList("_type", "tag.raw", "projectKey.raw", "type_raw")).put((Object)IndexableType.DATA_COLLECTION, Arrays.asList("_type", "tag.raw")).put((Object)IndexableType.KNOWLEDGE_BANK, Arrays.asList("_type", "tag.raw", "projectKey.raw")).put((Object)IndexableType.PROMPT_STUDIO, Arrays.asList("_type", "tag.raw", "projectKey.raw")).put((Object)IndexableType.CHART, Arrays.asList("_type", "projectKey.raw", "objectType", "user", "type_raw", "dataset")).build();
    @Autowired
    protected PubSubService pubSub;
    protected AbstractIndexingQueueHandler indexingQueueHandler;
    protected static final DKULogger logger = DKULogger.getLogger((String)AbstractSearchService.class.getCanonicalName());

    public boolean isInitialized() {
        return this.getQueueHandler().initialized;
    }

    @PostConstruct
    public void start() throws Exception {
        this.pubSub.subscribe("lucene-init-index", (DSSEventListener)this);
        this.subscribeEvents();
    }

    public void on(BackendEvent e) {
        try {
            if (e instanceof LuceneInitIndexEvent) {
                logger.info((Object)"LuceneInitIndexEvent received, starting queue handler thread");
                this.indexingQueueHandler = this.getQueueHandler();
                new Thread(this.indexingQueueHandler).start();
            }
            if (this.indexingQueueHandler == null) {
                logger.info((Object)("LuceneInitIndexEvent not received yet, dropping event " + e.getName()));
                return;
            }
            this.indexingQueueHandler.queue.put(e);
        }
        catch (Exception ex) {
            logger.debug((Object)("Failed to add " + e.getName() + " event to indexer queue"), (Throwable)ex);
        }
    }

    protected void addAggregationsAndFilters(Map<String, List<String>> facets, IndexableType type, FacetsConfig facetsConfig, Set<String> booleanFields, LuceneQueryWrapper luceneQueryWrapper) {
        List<String> typeFacet;
        assert (FACETS_FOR_TYPE.containsKey(type));
        HashMap<String, BooleanQuery> facetFilterMap = new HashMap<String, BooleanQuery>();
        HashSet fields = new HashSet();
        List<String> list = typeFacet = facets != null ? facets.get("_type") : null;
        if (typeFacet != null && !typeFacet.isEmpty()) {
            for (String string : typeFacet) {
                fields.addAll(FACETS_FOR_TYPE.get(IndexableType.forName((String)string)));
                luceneQueryWrapper.addRequestedType(IndexableType.forName((String)string));
            }
        } else {
            luceneQueryWrapper.addRequestedType(type);
            fields.addAll(FACETS_FOR_TYPE.get(type));
        }
        if (facets != null) {
            for (Map.Entry entry : facets.entrySet()) {
                String string = (String)entry.getKey();
                if (!fields.contains(string) || string.equals("_type") && (type == IndexableType.ALL || type == IndexableType.FEATURE_GROUP || type == IndexableType.FEATURE)) continue;
                BooleanQuery.Builder boolQueryBuilder = new BooleanQuery.Builder();
                List facetFilterValueList = (List)entry.getValue();
                if (facetFilterValueList.isEmpty()) continue;
                for (String filterValue : facetFilterValueList) {
                    if (booleanFields.contains(string)) {
                        String boolFilterValue = AbstractSearchService.getBoolValue(filterValue);
                        boolQueryBuilder.add((Query)new TermQuery(new Term(string, boolFilterValue)), BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    boolQueryBuilder.add((Query)new TermQuery(new Term(string, filterValue)), BooleanClause.Occur.SHOULD);
                }
                BooleanQuery boolQuery = boolQueryBuilder.build();
                facetFilterMap.put(string, boolQuery);
            }
        }
        if (!facetFilterMap.isEmpty()) {
            BooleanQuery.Builder postFilterQueryBuilder = new BooleanQuery.Builder();
            for (Map.Entry entry : facetFilterMap.entrySet()) {
                postFilterQueryBuilder.add((Query)entry.getValue(), BooleanClause.Occur.FILTER);
            }
            luceneQueryWrapper.setPostFilterQuery(postFilterQueryBuilder.build());
        }
        for (String string : fields) {
            if (!facetsConfig.getDimConfigs().containsKey(FACET_PREFIX + string)) {
                logger.warn((Object)("skipping unfaceted field " + string));
                continue;
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            boolean hasFilter = false;
            for (Map.Entry entry : facetFilterMap.entrySet()) {
                if (((String)entry.getKey()).equals(string)) continue;
                hasFilter = true;
                builder.add((Query)entry.getValue(), BooleanClause.Occur.FILTER);
            }
            if (hasFilter) {
                luceneQueryWrapper.addFacet(string, builder.build());
                continue;
            }
            luceneQueryWrapper.addFacet(string);
        }
    }

    private static String getBoolValue(String rawValue) {
        if ("0".equals(rawValue) || "false".equalsIgnoreCase(rawValue)) {
            return "false";
        }
        if ("1".equals(rawValue) || "true".equalsIgnoreCase(rawValue)) {
            return "true";
        }
        throw new IllegalArgumentException("incorrect value received for a boolean field filter");
    }

    public abstract AbstractIndexingQueueHandler getQueueHandler();

    public abstract void subscribeEvents();

    public static boolean isEscapedQueryString(String queryString) {
        if (StringUtils.isEmpty((String)queryString)) {
            return true;
        }
        String unEscapedQueryString = queryString.replaceAll("(\\\\?)\\\\", "$1");
        return QueryParser.escape((String)unEscapedQueryString).equals(queryString);
    }

    public static List<String> splitByWord(String input) {
        ArrayList<String> output = new ArrayList<String>();
        boolean inQuotes = false;
        boolean escaped = false;
        int startOfWord = -1;
        for (int current = 0; current < input.length(); ++current) {
            char chr = input.charAt(current);
            if (Character.isWhitespace(chr)) {
                if (startOfWord >= 0 && !inQuotes) {
                    output.add(input.substring(startOfWord, current));
                    startOfWord = -1;
                }
                escaped = false;
                continue;
            }
            if (chr == '\"') {
                if (startOfWord == -1) {
                    startOfWord = current - (escaped ? 1 : 0);
                }
                if (!escaped) {
                    inQuotes = !inQuotes;
                }
                escaped = false;
                continue;
            }
            if (chr == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (startOfWord == -1) {
                startOfWord = current - (escaped ? 1 : 0);
            }
            escaped = false;
        }
        if (startOfWord != -1) {
            output.add(input.substring(startOfWord));
        }
        return output;
    }

    public static String expandQueryString(String queryString) {
        if (StringUtils.isBlank((String)queryString)) {
            return "*";
        }
        queryString = Normalizer.normalize(queryString, Normalizer.Form.NFC);
        Stream<String> expandedQueryStream = AbstractSearchService.splitByWord(queryString).stream().flatMap(word -> {
            if (!AbstractSearchService.isEscapedQueryString(word)) {
                return Stream.of(word);
            }
            return Arrays.stream(word.split(UNDERSCORE_SEPARATOR.pattern())).map(AbstractSearchService::expandWordUsingCamelCase);
        });
        return expandedQueryStream.collect(Collectors.joining(" "));
    }

    private static String expandWordUsingCamelCase(String wordString) {
        if (CAMELCASE_SEPARATOR.matcher(wordString).find()) {
            Stream<String> splitByCamelWord = Arrays.stream(CAMELCASE_SEPARATOR.split(wordString)).map(AbstractSearchService::expandSimpleWord);
            return "(" + AbstractSearchService.expandSimpleWord(wordString) + " OR (" + splitByCamelWord.collect(Collectors.joining(" ")) + "))";
        }
        return AbstractSearchService.expandSimpleWord(wordString);
    }

    protected static String expandSimpleWord(String wordString) {
        String matcher = wordString.length() <= 4 ? "$1($2^3 OR ($2*))" : "$1($2^3 OR $2~1^2 OR ($2*))";
        return SIMPLE_WORD.matcher(wordString).replaceAll(matcher);
    }

    protected void checkIndexReady() throws LuceneIndexException {
        if (!LuceneConfiguration.IS_CATALOG_ENABLED) {
            throw new IndexingDisabledException();
        }
        if (this.getQueueHandler() == null || !this.getQueueHandler().isInitialized()) {
            throw new IndexNotBuiltException();
        }
    }

    public void prepareSearch(Map<String, List<String>> facets, FacetsConfig facetsConfig, Set<String> booleanFields, LuceneQueryWrapper luceneQueryWrapper) throws LuceneIndexException {
        this.checkIndexReady();
        IndexableType currentType = facets == null || facets.get("_type") == null || facets.get("_type").isEmpty() ? IndexableType.ALL : IndexableType.forName((String)facets.get("_type").get(0));
        this.addAggregationsAndFilters(facets, currentType, facetsConfig, booleanFields, luceneQueryWrapper);
    }

    public static String escapeReservedLuceneWords(String wordString) {
        return Arrays.stream(wordString.split("\\s")).map(w -> Arrays.asList("OR", "AND", "NOT").contains(w) ? w.toLowerCase() : w).collect(Collectors.joining(" "));
    }

    public static boolean isDocumentOfType(Document partialDocument, IndexableType documentType) {
        IndexableField documentTypeField = partialDocument.getField("_type");
        return documentTypeField != null && documentType.index().equals(documentTypeField.stringValue());
    }

    public static Query buildQueryFieldIs(String fieldName, String fieldValue) {
        return new TermQuery(new Term(fieldName, fieldValue));
    }

    public static Query buildQueryTypeIs(IndexableType documentType) {
        return AbstractSearchService.buildQueryFieldIs("_type", documentType.index());
    }

    public Query buildStringQueryForType(IndexableType docType, LuceneIndexManager indexManager, Map<String, Float> fieldsWithBoosts, String rawQuery) throws ParseException {
        return this.buildStringQuery(AbstractSearchService.escapeReservedLuceneWords(rawQuery), fieldsWithBoosts.keySet().toArray(new String[0]), fieldsWithBoosts, indexManager.getMappingsAnalyzer().getPerFieldAnalyzerWrapper(docType.index()), indexManager.getMappingsAnalyzer().getMappingForType(docType.index()));
    }

    public Query buildStringQuery(String queryString, String[] fields, Map<String, Float> boosts, PerFieldAnalyzerWrapper wrapper, Map<String, LuceneMappingsAnalyzer.Field> fieldsMapping) throws ParseException {
        return this.buildStringQuery(queryString, fields, boosts, wrapper, true, fieldsMapping, true);
    }

    public Query buildStringQuery(String queryString, String[] fields, Map<String, Float> boosts, PerFieldAnalyzerWrapper wrapper, Boolean setAutoGeneratePhraseQueries, Map<String, LuceneMappingsAnalyzer.Field> fieldsMapping, boolean analyzeWildcard) throws ParseException {
        return this.buildStringQueryFromInputString(queryString, fields, boosts, wrapper, setAutoGeneratePhraseQueries, true, fieldsMapping, analyzeWildcard);
    }

    public Query buildStringQueryForHighlight(String queryString, String[] fields, Map<String, Float> boosts, PerFieldAnalyzerWrapper wrapper, Map<String, LuceneMappingsAnalyzer.Field> fieldsMapping, boolean analyzeWildcard) throws ParseException {
        return this.buildStringQueryFromInputString(queryString, fields, boosts, wrapper, true, false, fieldsMapping, analyzeWildcard);
    }

    public Query buildStringQueryFromInputString(String queryString, String[] fields, Map<String, Float> boosts, PerFieldAnalyzerWrapper wrapper, Boolean setAutoGeneratePhraseQueries, boolean mustExpand, Map<String, LuceneMappingsAnalyzer.Field> fieldsMapping, boolean analyzeWildcard) throws ParseException {
        if (StringUtils.isBlank((String)queryString)) {
            return new MatchAllDocsQuery();
        }
        CustomMultiFieldQueryParser queryParser = new CustomMultiFieldQueryParser(fields, (Analyzer)wrapper, boosts, fieldsMapping, analyzeWildcard);
        queryParser.setSplitOnWhitespace(true);
        queryParser.setAutoGeneratePhraseQueries(setAutoGeneratePhraseQueries);
        queryParser.setDefaultOperator(QueryParser.Operator.AND);
        return queryParser.parse(mustExpand ? AbstractSearchService.expandQueryString(queryString) : queryString);
    }

    public BooleanQuery.Builder buildBoolQueryBuilder(Query query, AuthCtx user) throws IOException, DKUSecurityException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST);
        if (!user.isAdmin()) {
            booleanQueryBuilder.add(this.accessFilter(user), BooleanClause.Occur.FILTER);
        }
        for (IndexableType type : IndexableType.values()) {
            ConstantScoreQuery innerBoostQuery = new ConstantScoreQuery((Query)new TermQuery(new Term("_type", type.index())));
            booleanQueryBuilder.add((Query)new BoostQuery((Query)innerBoostQuery, type.boost()), BooleanClause.Occur.SHOULD);
        }
        return booleanQueryBuilder;
    }

    protected abstract Query accessFilter(AuthCtx var1) throws IOException, DKUSecurityException;

    public BlockingQueue<BackendEvent> debugOnlyGetIndexerQueue() {
        return this.indexingQueueHandler.queue;
    }

    protected void addHitsInResponse(LuceneSecureIndexReader secureIndexReader, IndexableType docType, TopDocs topDocs, LuceneResponseWrapper result, LuceneIndexManager indexManager) throws IOException {
        this.addHitsInResponse(secureIndexReader, docType, topDocs, result, indexManager, null, null, null, null);
    }

    protected void addHitsInResponse(LuceneSecureIndexReader secureIndexReader, IndexableType docType, TopDocs topDocs, LuceneResponseWrapper result, LuceneIndexManager indexManager, Set<String> fieldsToHighlight, Map<String, Boolean> isTermVectorEnabledByField, Query query, PerFieldAnalyzerWrapper analyzer) throws IOException {
        result.totalHits = new TotalHitsCount(topDocs.totalHits);
        LuceneMappingsAnalyzer lma = indexManager.getMappingsAnalyzer();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            Document document = secureIndexReader.document(scoreDoc.doc, docType);
            LuceneResponseWrapper.Hit hit = new LuceneResponseWrapper.Hit(indexManager.getIndexName());
            Set multiValuedFields = lma.getMultivaluedFieldSetForType(document.getField("_type").stringValue());
            if (fieldsToHighlight != null && !fieldsToHighlight.isEmpty()) {
                try {
                    LuceneHighlighter.highlight(query, secureIndexReader, document, scoreDoc.doc, fieldsToHighlight, multiValuedFields, isTermVectorEnabledByField, analyzer, hit);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to highlight search results", (Throwable)e);
                }
            }
            LuceneHelpers.convertDocumentToSourceMap(document, (LuceneResponseWrapper.HitCommon)hit, lma);
            hit._score = scoreDoc.score;
            result.hits.add(hit);
        }
    }

    protected void searchFacets(IndexSearcher searcher, LuceneSecureIndexReader secureIndexReader, LuceneQueryWrapper luceneQueryWrapper, LuceneResponseWrapper result) throws IOException {
        if (!secureIndexReader.isIndexEmpty()) {
            Map<String, FacetsCollector> facetsCollectorMap = this.searchFacetsAndFillCollectors(searcher, luceneQueryWrapper);
            for (Map.Entry<String, FacetsCollector> entry : facetsCollectorMap.entrySet()) {
                this.addAggregationInResponse(entry.getValue(), secureIndexReader, Collections.singletonList(entry.getKey()), result);
            }
        }
    }

    protected void addAggregationInResponse(FacetsCollector facetsCollector, LuceneSecureIndexReader secureIndexReader, List<String> facetsFieldList, LuceneResponseWrapper result) throws IOException {
        ArrayList<SortedSetDocValuesFacetCounts> facetsList = new ArrayList<SortedSetDocValuesFacetCounts>();
        for (String facetField : facetsFieldList) {
            DefaultSortedSetDocValuesReaderState state = new DefaultSortedSetDocValuesReaderState(secureIndexReader.getIndexReader(), FACET_PREFIX + facetField);
            facetsList.add(new SortedSetDocValuesFacetCounts((SortedSetDocValuesReaderState)state, facetsCollector));
        }
        Set booleanFields = secureIndexReader.getMappingsAnalyzer().getBooleanFieldCondensedSet();
        for (int i = 0; i < facetsList.size(); ++i) {
            FacetResult facetResult;
            String facetName = facetsFieldList.get(i);
            Facets facets = (Facets)facetsList.get(i);
            FacetResult facetResult2 = facetResult = facets == null ? null : facets.getTopChildren(1000, FACET_PREFIX + facetName, new String[0]);
            if (facetResult == null) {
                result.aggregations.put(facetName, new LuceneResponseWrapper.Aggregation(new ArrayList(), 0L, booleanFields.contains(facetName)));
                continue;
            }
            List labelAndValueList = Arrays.stream(facetResult.labelValues).map(lv -> "__DKU__EMPTY__VALUE__".equals(lv.label) ? new LabelAndValue("", lv.value) : lv).collect(Collectors.toCollection(ArrayList::new));
            long docCount = facetsCollector.getMatchingDocs().stream().map(docs -> docs.totalHits).mapToLong(Integer::longValue).sum();
            LuceneResponseWrapper.Aggregation aggregation = new LuceneResponseWrapper.Aggregation(labelAndValueList, docCount, booleanFields.contains(facetName));
            result.aggregations.put(facetName, aggregation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuceneResponseWrapper getLuceneDocById(String docId, IndexableType docType, LuceneIndexManager indexManager) throws IOException, LuceneIndexException {
        this.checkIndexReady();
        BooleanQuery getDocByIdQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_id", docId)), BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term("_type", docType.index())), BooleanClause.Occur.FILTER).build();
        LuceneResponseWrapper response = new LuceneResponseWrapper();
        IndexSearcher indexSearcher = indexManager.acquireIndexSearcher();
        try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.search.getDocById");){
            TopDocs topDocs = indexSearcher.search((Query)getDocByIdQuery, 1);
            this.addHitsInResponse(indexManager.getSecureIndexReader(indexSearcher), docType, topDocs, response, indexManager);
            response.serializeJsonPayloads(indexManager.getMappingsAnalyzer().getJsons(docType.index()));
        }
        finally {
            indexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        return response;
    }

    private Map<String, FacetsCollector> searchFacetsAndFillCollectors(IndexSearcher searcher, LuceneQueryWrapper luceneQueryWrapper) throws IOException {
        HashMap<String, FacetsCollector> facetsCollectorsMap = new HashMap<String, FacetsCollector>();
        for (Map.Entry entry : luceneQueryWrapper.getFacetsQueriesMap().entrySet()) {
            String facetName = (String)entry.getKey();
            FacetsCollector facetsCollector = new FacetsCollector();
            BooleanQuery.Builder facetBoolQueryBuilder = new BooleanQuery.Builder().add(luceneQueryWrapper.getQuery(), BooleanClause.Occur.FILTER);
            facetBoolQueryBuilder.add((Query)new TermQuery(new Term(facetName, "__DKU__NULL__VALUE__")), BooleanClause.Occur.MUST_NOT);
            if (entry.getValue() != null) {
                facetBoolQueryBuilder.add((Query)entry.getValue(), BooleanClause.Occur.FILTER);
            }
            searcher.search((Query)facetBoolQueryBuilder.build(), (Collector)facetsCollector);
            if (facetsCollector.getMatchingDocs().stream().allMatch(collector -> {
                try {
                    return collector.context.reader().getSortedSetDocValues(FACET_PREFIX + facetName) == null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })) {
                logger.warn((Object)("No doc values found with value " + facetName + ". Facet will be filtered out."));
                continue;
            }
            facetsCollectorsMap.put(facetName, facetsCollector);
        }
        return facetsCollectorsMap;
    }
}

