/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.codeenvs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.DesignNodeCodeEnvPackagePresets;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class DSSCodeEnvPresetsRequirementsMain {
    public static void main(String[] args) throws Exception {
        File installDir = DSSCodeEnvPresetsRequirementsMain.initAndGetInstallDir();
        boolean useConda = false;
        String corePackageSet = "DEFAULT";
        CodeEnvModel.PythonEnvDesc envDesc = new CodeEnvModel.PythonEnvDesc();
        envDesc.installCorePackages = true;
        envDesc.conda = false;
        for (StandardPythonInterpreter interpreter : StandardPythonInterpreter.values()) {
            List presets = DesignNodeCodeEnvPackagePresets.forPython((StandardPythonInterpreter)interpreter, (boolean)useConda, (String)corePackageSet);
            presets.forEach(preset -> {
                try {
                    CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet[] corePythonPackagesSetArray = CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet.values();
                    int n = corePythonPackagesSetArray.length;
                    for (int i = 0; i < n; ++i) {
                        CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet set;
                        envDesc.corePackagesSet = set = corePythonPackagesSetArray[i];
                        String requirementsTxtFileName = "requirements_" + set.toString() + ".txt";
                        String requirementsPath = String.valueOf(installDir) + "/resources/code-envs/python/generated-presets/" + String.valueOf(interpreter) + "/" + preset.getId().toLowerCase() + "/" + requirementsTxtFileName;
                        DKUFileUtils.mkdirsParent((File)new File(requirementsPath));
                        String mandatoryPackagesString = CodeEnvPackageSystems.PIP.getMandatoryPackageList((CodeEnvModel.AbstractEnvDesc)envDesc);
                        String requirementsString = mandatoryPackagesString + preset.getRequirementsString();
                        Files.write(Paths.get(requirementsPath, new String[0]), requirementsString.getBytes(), new OpenOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static File initAndGetInstallDir() throws IOException {
        String installDirStr = System.getenv("DKUINSTALLDIR");
        if (installDirStr == null) {
            throw new RuntimeException("DKUINSTALLDIR is not set");
        }
        Path dir = Files.createTempDirectory("generate_code_env_presets", new FileAttribute[0]);
        File installDir = new File(installDirStr).getCanonicalFile();
        File propsFile = new File(dir.toFile(), "config/dip.properties");
        DKUFileUtils.mkdirsParent((File)propsFile);
        FileUtils.write((File)propsFile, (CharSequence)"");
        DKUApp.setSecurityFlags((boolean)false, (boolean)false, (boolean)false);
        ApplicationConfigurator.setBaseFolder((String)dir.toString(), (String)installDir.getAbsolutePath());
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.BACKEND);
        ApplicationConfigurator.touchProperties();
        if (!Files.exists(Paths.get(installDirStr + "/resources/code-envs/python/generated-presets", new String[0]), new LinkOption[0])) {
            Files.createDirectory(Paths.get(installDirStr + "/resources/code-envs/python/generated-presets", new String[0]), new FileAttribute[0]);
        }
        return installDir;
    }
}

