/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.api;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.OAuthWebConnection;
import com.databricks.client.hivecommon.api.SSOSAMLWebConnection;
import com.databricks.client.hivecommon.api.WebConnection;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebServer
implements Runnable {
    private AtomicBoolean m_continueFlag;
    private ExecutorService m_executorService;
    private ILogger m_logger;
    private ServerSocket m_serverSocket;
    private HiveJDBCSettings m_settings;
    private WebConnection.SetValueFunction m_setValueFunction;

    public WebServer(ServerSocket serverSocket, ExecutorService executorService, WebConnection.SetValueFunction setValueFunction, AtomicBoolean atomicBoolean, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        this.m_setValueFunction = setValueFunction;
        this.m_executorService = executorService;
        this.m_continueFlag = atomicBoolean;
        this.m_serverSocket = serverSocket;
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
    }

    @Override
    public void run() {
        LogUtilities.logDebug("Start listening for browser connections.", this.m_logger);
        while (this.m_continueFlag.get()) {
            try {
                Socket socket = this.m_serverSocket.accept();
                if (this.m_settings.m_oAuthSettings != null) {
                    this.m_executorService.submit(new OAuthWebConnection(socket, this.m_setValueFunction, this.m_logger, this.m_settings.m_ssoSettings));
                    continue;
                }
                this.m_executorService.submit(new SSOSAMLWebConnection(socket, this.m_setValueFunction, this.m_logger, this.m_settings.m_ssoSettings));
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                LogUtilities.logDebug("IO exception while connecting to .", this.m_logger);
            }
        }
        LogUtilities.logDebug("Server response found, not listening for new connections.", this.m_logger);
    }
}

