/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl;

import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableTimeMilliHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.TimeMilliHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.DateUtility;
import java.time.LocalDateTime;

public class NullableTimeMilliHolderReaderImpl
extends AbstractFieldReader {
    private NullableTimeMilliHolder holder;

    public NullableTimeMilliHolderReaderImpl(NullableTimeMilliHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMEMILLI;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(TimeMilliHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeMilliHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        if (!this.isSet()) {
            return null;
        }
        return DateUtility.getLocalDateTimeFromEpochMilli(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }
}

