/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.jwk;

import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWK;
import com.databricks.client.jdbc42.internal.nimbusjose.util.Base64URL;
import com.databricks.client.jdbc42.internal.nimbusjose.util.JSONObjectUtils;
import com.databricks.client.jdbc42.internal.nimbusjose.util.StandardCharset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;

public final class ThumbprintUtils {
    public static Base64URL compute(JWK jwk) throws JOSEException {
        return ThumbprintUtils.compute("SHA-256", jwk);
    }

    public static Base64URL compute(String hashAlg, JWK jwk) throws JOSEException {
        LinkedHashMap<String, ?> orderedParams = jwk.getRequiredParams();
        return ThumbprintUtils.compute(hashAlg, orderedParams);
    }

    public static Base64URL compute(String hashAlg, LinkedHashMap<String, ?> params) throws JOSEException {
        MessageDigest md;
        String json = JSONObjectUtils.toJSONString(params);
        try {
            md = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException("Couldn't compute JWK thumbprint: Unsupported hash algorithm: " + e.getMessage(), e);
        }
        md.update(json.getBytes(StandardCharset.UTF_8));
        return Base64URL.encode(md.digest());
    }
}

