(function() {
    'use strict';

    const cutoffTimeModalBody = {
        templateUrl: 'static/dataiku/auto-feature-generation/cutoff-time-modal/cutoff-time-modal-body.component.html',
        bindings: {
            params: '=',
            inputs: '<',
            computablesMap: '<',
            dismiss : '<',
            updateRecipeStatus: '<'
        },
        controller: function(AutoFeatureGenerationRecipeService) {
            const ctrl = this;
            ctrl.$onInit = () => {
                ctrl.CUTOFF_TIME_MODE = AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE;
                ctrl.currentCutoffTimeMode = ctrl.params.cutoffTime.mode;
                ctrl.currentTimeIndexColumn = ctrl.params.virtualInputs[0].timeIndexColumn;
                ctrl.primaryDatasetName = AutoFeatureGenerationRecipeService.getDatasetName(0, ctrl.params.virtualInputs, ctrl.inputs);
                ctrl.dateColumnsFromPrimaryDataset = AutoFeatureGenerationRecipeService.getDateColumnsFromDataset(ctrl.primaryDatasetName, ctrl.computablesMap);
                if(!AutoFeatureGenerationRecipeService.hasDateColumns(ctrl.primaryDatasetName, ctrl.computablesMap) && ctrl.params.cutoffTime.mode===AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DATE_COLUMN.name) {
                    ctrl.currentCutoffTimeMode = AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.name;
                }
                ctrl.currentTimeIndexColumn = AutoFeatureGenerationRecipeService.autoSelectDateColumn(ctrl.currentTimeIndexColumn, ctrl.dateColumnsFromPrimaryDataset);
            };

            ctrl.primaryDatasetTooltip = AutoFeatureGenerationRecipeService.PRIMARY_DATASET_TOOLTIP;

            ctrl.editCutoffTime = function() {
                ctrl.params.cutoffTime.mode = ctrl.currentCutoffTimeMode;
                if (ctrl.params.cutoffTime.mode===AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.name) {
                    AutoFeatureGenerationRecipeService.resetTimeIndexes(ctrl.params.virtualInputs)
                } else {
                    ctrl.params.virtualInputs[0].timeIndexColumn = ctrl.currentTimeIndexColumn;
                }
                ctrl.updateRecipeStatus();
                ctrl.dismiss();
            }

            ctrl.disableSave = function() {
                return !AutoFeatureGenerationRecipeService.isCutoffTimeValid(ctrl.currentCutoffTimeMode, ctrl.currentTimeIndexColumn)
            }

        },
    }

    angular.module('dataiku.autoFeatureGeneration')
        .component('cutoffTimeModalBody', cutoffTimeModalBody);
})();