(function() {
    'use strict';

    const app = angular.module('dataiku.analysis.mlcore');

    app.controller("TimeseriesInteractiveScoringAnalysis", function($scope, PMLSettings, DataikuAPI, PerTimeseriesService, TimeseriesForecastingUtils, FutureProgressModal, $stateParams, Ng2InteractiveScoringScenariosSaveService, LocalStorage) {

        $scope.hasExternalFeatures = false;
        $scope.perFeatures = {};
        $scope.selectedTimeseriesIdentifier = null;
        $scope.scenariosForecasts = null;
        $scope.isDashboardTile = false;

        $scope.dashboardTileView = 'forecasts';
        $scope.toggleView = function() {
            $scope.dashboardTileView = $scope.dashboardTileView === 'forecasts' ? 'scenarios' : 'forecasts';
        }
        
        const deregister = $scope.$watch('modelData', function() {
            if (!$scope.modelData) return;

            $scope.perFeatures = $scope.modelData.preprocessing.per_feature;
            $scope.isDashboardTile = !!$stateParams.dashboardId;
            $scope.objectId = $scope.isDashboardTile ? `insightId.interactiveScoring.${$scope.insight.id}` : `fullModelId.interactiveScoring.${$scope.modelData.fullModelId}`;

            if (!TimeseriesForecastingUtils.ALGOS_WITHOUT_EXTERNAL_FEATURES.names.includes($scope.modelData.modeling.algorithm)){
                if (Object.values($scope.modelData.preprocessing.per_feature).some(f => f.role === "INPUT")) {
                    $scope.hasExternalFeatures = true;
                    $scope.createScenario();
                    $scope.getScenarioForecasts();
                }
            }
            deregister()
        });

        $scope.createScenario = function() {
            DataikuAPI.ml.prediction.createInteractiveScoringScenario($scope.modelData.fullModelId)
                .then(function (res) {
                    FutureProgressModal.show($scope, res.data, "Create timeseries scenarios").then(function (result) {
                        if (result) {
                            $scope.scenarios = result;
                            const key = 'dss.ml.forecastChart.' + $scope.objectId + '.filters';
                            const unparsedTimeseriesArray = Object.keys($scope.scenarios);
                            if (unparsedTimeseriesArray.length > 1) {
                                $scope.allTimeseriesIdentifierValuesMap = PerTimeseriesService.initTimeseriesIdentifiersValues($scope.modelData.coreParams.timeseriesIdentifiers);
                                if (!sessionStorage.getItem(key)) {
                                    sessionStorage.setItem(key, unparsedTimeseriesArray[0]);
                                    LocalStorage.set(key, JSON.parse(unparsedTimeseriesArray[0]));
                                }
                                unparsedTimeseriesArray.forEach(function(unparsedTimeseriesIdentifier) {
                                    const parsedTimeseriesIdentifier = JSON.parse(unparsedTimeseriesIdentifier);
                                    PerTimeseriesService.addIdentifierValues(parsedTimeseriesIdentifier, $scope.modelData.coreParams.timeseriesIdentifiers, $scope.allTimeseriesIdentifierValuesMap);
                                });
                                PerTimeseriesService.removeDuplicatesAndSortIdentifierValuesForFilterDropdowns($scope.allTimeseriesIdentifierValuesMap);
                            }
                            $scope.updateSelectedIdentifier();
                            $scope.updateDisplayedTimeseries();
                        }
                    });
                })
                .catch(setErrorInScope.bind($scope));
        }

        $scope.computeScenariosForecasts = function() {
            // Call the interactive-scoring-scenarios-save to save changes if needed, then proceed with compute
            Ng2InteractiveScoringScenariosSaveService.triggerSave().then(function(saveSuccess) {
                if (saveSuccess) {
                    DataikuAPI.ml.prediction.computeInteractiveScoringScenario($scope.modelData.fullModelId, $scope.selectedTimeseriesIdentifier)
                        .then(function (res) {
                            FutureProgressModal.show($scope, res.data, "Compute scenarios forecasts").then(function (result) {
                                if (result) {
                                    $scope.scenariosForecasts = result;
                                    $scope.updateDisplayedTimeseries()
                                    $scope.dashboardTileView = 'forecasts';
                                }
                            });
                        }).catch(setErrorInScope.bind($scope));
                }
            }, function(error) {
                setErrorInScope.bind($scope)(error);
            });
        };

        $scope.getScenarioForecasts = function() {
            DataikuAPI.ml.prediction.getInteractiveScoringForecasts($scope.modelData.fullModelId).success(function(data) {
                if (!Object.keys(data).length) {
                    $scope.scenariosForecasts = {};
                } else {
                    $scope.scenariosForecasts = data;
                }
                $scope.updateDisplayedTimeseries();
            }).error(setErrorInScope.bind($scope));
        }

        $scope.$on('timeseriesIdentifiersFiltersUpdated', function(event, filters) {
            $scope.updateSelectedIdentifier(filters);
            $scope.updateDisplayedTimeseries();
        });

        $scope.updateDisplayedTimeseries = function() {
            if (!$scope.scenariosForecasts || !$scope.selectedTimeseriesIdentifier) {
                $scope.displayedTimeseriesForecasts = undefined;
                return;
            }

            if (!$scope.scenariosForecasts[$scope.selectedTimeseriesIdentifier]) { // If no scenario -> compute first
                $scope.computeScenariosForecasts();
            }
            $scope.displayedTimeseriesForecasts = $scope.scenariosForecasts[$scope.selectedTimeseriesIdentifier];
        };

        $scope.updateSelectedIdentifier = function(filters) {
            if (!$scope.scenarios || !Object.keys($scope.scenarios).length) {
                $scope.selectedTimeseriesIdentifier = null;
                return;
            }

            const scenarioKeys = Object.keys($scope.scenarios);

            // If there's only one time series, it's selected by default.
            if (scenarioKeys.length === 1) {
                $scope.selectedTimeseriesIdentifier = scenarioKeys[0];
                return;
            }

            if (!filters) {
                $scope.selectedTimeseriesIdentifier = null;
                return;
            }

            $scope.selectedTimeseriesIdentifier = scenarioKeys.find(key => {
                try { return angular.equals(JSON.parse(key), filters); } catch (e) { return false; }
            }) || null;
        };
    });
})();
