(function() {
'use strict';

var app = angular.module('dataiku.datasets');


app.controller("BaseEditableDatasetController", function($scope, $stateParams, DatasetUtils) {
    DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey, "sync").then(function(data){
        $scope.availableInputDatasets = data[0].filter(function(ds){
            // remove self
            return ds.name != $stateParams.datasetName || ds.projectKey != $stateParams.projectKey;
        });
    });
    $scope.dataset.managed = true;//Editable datasets are always managed
});


/* Settings controller (also used in new dataset page) */
app.controller("EditableDatasetController", function($scope, $stateParams, $controller, DataikuAPI, LoggerProvider) {
    $controller("BaseEditableDatasetController", {$scope: $scope});
    $controller("BaseUploadedFilesController", {$scope: $scope});
    $controller("ManagedFSLikeDatasetController", {$scope: $scope});

    var Logger = LoggerProvider.getLogger('datasets.editable');

    $scope.dataset.params = $scope.dataset.params || {};
    $scope.dataset.flowOptions = $scope.dataset.flowOptions || {};
    $scope.dataset.flowOptions.rebuildBehavior = $scope.dataset.flowOptions.rebuildBehavior || 'WRITE_PROTECT';
    $scope.dataset.flowOptions.crossProjectBuildBehavior = $scope.dataset.flowOptions.crossProjectBuildBehavior || 'STOP';

    $scope.interactionType = 'editable';
    $scope.uiState.autoTestOnFileSelection = true;

    $scope.test = function () {
        $scope.testing = true;
        $scope.testResult = null;
        DataikuAPI.datasets.editable.test($stateParams.projectKey, angular.toJson($scope.dataset)).then(
        function (data) {
            $scope.testing = false;
            $scope.testResult = data;
            if (!$scope.dataset.name) {
                $scope.uiState.new_dataset_name = $scope.testResult.suggestedName;
            }
            if ($scope.testResult.tableSchema && (!$scope.dataset.schema || !$scope.dataset.schema.columns == 0 || !$scope.dataset.schema.columns.length)) {
                // Overwrite schema using detected schema, if we have none
                $scope.dataset.schema = {
                        'userModified': false,
                        'columns': $scope.testResult.tableSchema.columns
                };
                $scope.testResult.schemaMatchesTable = true;
            }
        }, function (data) {
            $scope.testing = false;
        });
    };

    // Cannot save if downloading
    $scope.saveHooks.push(function() {
        return $scope.downloadingFiles == 0;
    });

    $scope.saveHooks.push(function() {
        var params = $scope.dataset.params;
        if(params.importSourceType == 'NONE') {
            return true;
        } else if(params.importSourceType == 'DATASET') {
            return !!params.importDatasetSmartName;
        } else if(params.importSourceType == 'FILE') {
            return $scope.files && $scope.files.length > 0;
        }
        Logger.warn("unknown source type", params.importSourceType);
    });

    $scope.onLoadComplete = function(){
        $scope.test(true);
    };

    // list of uploaded files (with finished upload)
    $scope.$watch(function () {
        return $.grep($scope.files, function (f) {
            return angular.isUndefined(f.progress);
        });
    }, function (nv, ov) {
        if (nv !== ov) {
            $scope.onCoreParamsChanged();
        }
    }, true);

    $scope.dataset.params = $scope.dataset.params || {};
    $scope.dataset.params.importSourceType = 'NONE';
    $scope.editableDataset = true;
});


/* Edit tab controller */
app.controller("DatasetEditController", function($scope, $stateParams, TopNav) {
    TopNav.setLocation(TopNav.TOP_FLOW, "datasets", TopNav.TABS_DATASET, "edit");
    var getDatasetFromFullInfo = function() {
        if ($scope.datasetFullInfo) {
            $scope.dataset = $scope.datasetFullInfo.dataset;
        } else {
            $scope.dataset = null;
        }
    };
    $scope.datasetId = $stateParams.datasetName;
    $scope.projectKey = $stateParams.projectKey;
    $scope.contextProjectKey = $scope.context && $scope.context.projectKey ? $scope.context.projectKey:$scope.$stateParams.projectKey;
    $scope.$watch("datasetFullInfo", getDatasetFromFullInfo);
    getDatasetFromFullInfo();
});


app.controller("EditableDatasetImportController", function($scope, $rootScope, $stateParams, Dialogs, DataikuAPI, $controller) {
    $controller("BaseEditableDatasetController", {$scope: $scope});
    $controller("BaseUploadedFilesController", {$scope: $scope});

    function doImport() {
        $scope.dismiss();
        DataikuAPI.datasets.editable.import($stateParams.projectKey, $stateParams.datasetName, angular.toJson($scope.dataset))
            .success(
                function(data) {
                    $scope.loadData();
                    $scope.datasetSaved = true;
                }
            ).error(setErrorInScope.bind($rootScope));
    }

    $scope.isValid = function() {
        if ($scope.dataset.params.importSourceType == 'DATASET') {
            return !!$scope.dataset.params.importDatasetSmartName;
        }
        return true;
    };

    $scope.import = function() {
        Dialogs.confirm($scope, "Import data", "This operation cannot be reverted, are you sure you want to continue?").then(function() {
            if (!$scope.datasetSaved && $scope.dataset.params.importMode == 'APPEND') {
                $scope.saveDataset().then(doImport);
            } else {
                doImport();
            }
        });
    };
});

app.controller("EditableDatasetQuickCleanController", function($scope, Dialogs) {

    $scope.columns = true;
    $scope.rows = true;

    $scope.isValid = function() {
        if ($scope.rows || $scope.columns) {
            return true;
        }
        return false;
    };

    $scope.clean = function() {
        $scope.dismiss();
        if ($scope.columns) {
            $scope.contextOptions.deleteEmptyColumns();
        }
        if ($scope.rows) {
            $scope.contextOptions.deleteEmptyRows();
        }
    };
});

}());
