(function() {
'use strict';

const app = angular.module('dataiku.recipes');


app.controller("PromptRecipeCreationController", function(
    $scope, $stateParams, $controller, DataikuAPI) {

    $scope.recipeType = 'prompt';

    $controller("SingleOutputDatasetRecipeCreationController", {$scope:$scope});
    $scope.showOutputPane = _ => !!$scope.io.inputDataset;

    $scope.recipe = {
        inputs: {
            main: {
                items: [{
                    ref: ''
                }]
            }
        },
        outputs: {
            main: {
                items: []
            }
        }
    };

    DataikuAPI.flow.listUsableComputables($stateParams.projectKey, {
        datasetsOnly : false,
    }).then(function({ data }) {
        $scope.availableInputFolders = data.filter(computable => computable.type == 'MANAGED_FOLDER');
    }).catch(setErrorInScope.bind($scope));

    $scope.autosetName = function() {
        if ($scope.io.inputDataset) {
            const niceInputName = $scope.io.inputDataset.replace(/[A-Z]*\./, "");
            $scope.maybeSetNewDatasetName(niceInputName + "_generated");
        }
    };

    $scope.getCreationSettings = function() {
        const inputs = [];
        if ($scope.io.inputDataset) {
            inputs.push($scope.io.inputDataset);
        }
        const creationSettings = { virtualInputs: inputs };

        if ($scope.initialPayload) {
            creationSettings.initialPayload = $scope.initialPayload;
        }

        return creationSettings;
    };

    addDatasetUniquenessCheck($scope, DataikuAPI, $stateParams.projectKey);
    fetchManagedDatasetConnections($scope, DataikuAPI);

    $scope.$watch('io.inputDataset', function(nv) {
        if (nv) {
            $scope.recipe.inputs.main.items[0].ref = nv;
        }
    });

    $scope.$watch('io.inputImageFolder', function(nv) {
        if (nv) {
            if (!$scope.recipe.inputs.images) {
                $scope.recipe.inputs.images = {
                    items: [{
                        ref: ''
                    }]
                }
            }
            $scope.recipe.inputs.images.items[0].ref = nv;
        }
    });
});


app.controller("PromptRecipeEditor", function($scope, $controller, $stateParams, Debounce, PromptUtils, CreateModalFromTemplate, DataikuAPI) {
    $controller("_NLPLLMRecipeControllerBase", {$scope: $scope});

    $scope.loadLLMs("GENERIC_COMPLETION");

    $scope.getInputs = PromptUtils.getInputs;
    $scope.hasImageInput = PromptUtils.hasImageInput;

    $scope.addInput = function() {  // for structured prompts only
        PromptUtils.getInputs($scope.desc.prompt).push({
            name: '',
            datasetColumnName: undefined,
        });
        $scope.desc.prompt.structuredPromptExamples.forEach(example => {
            example.inputs.push('');
        });
    };

    $scope.deleteInput = function(index) {  // for structured prompts only
        PromptUtils.getInputs($scope.desc.prompt).splice(index, 1);
        $scope.desc.prompt.structuredPromptExamples.forEach(example => {
            example.inputs.splice(index, 1);
        });
    };

    $scope.updateInputCheck = Debounce().withDelay(300, 300).wrap(_ => { PromptUtils.updateInputCheck($scope.desc.prompt, $scope.activeLLM.supportsImageInputs) });

    $scope.openEditInStudioModal = function() {
        CreateModalFromTemplate("/templates/recipes/nlp/edit-in-studio.html", $scope, "EditInStudioModalController", function(newScope) {
        });
    };

    $scope.onPromptLLMChange = function() {
        $scope.onLLMChange();

        // update inputs
        PromptUtils.updateInputsOnLLMChange($scope.desc.prompt, $scope.activeLLM);

        // update retrievable knowledge input
        if ($scope.recipe && $scope.recipe.inputs) {
            const items = [];
            if ($scope.activeLLM && $scope.activeLLM.retrievableKnowledgeSmartId) {
                items.push({ ref: $scope.activeLLM.retrievableKnowledgeSmartId });
            }

            $scope.recipe.inputs.model = { items };
        }

    };

    var unwatch = $scope.$watch('desc', function(nv) {
        if (nv) {
            if (!$scope.desc.filter) {
                $scope.desc.filter = {
                    enabled: false,
                    distinct: false,
                    uiData: {
                        conditions: [],
                        mode: '&&'
                    }
                }
            }
            unwatch()
        }
    }, true);

    // add image input to desc
    $scope.$watch('recipe.inputs.images.items', function(nv) {
        if (nv) {
            $scope.desc.prompt.imageFolderId = (nv[0] || {}).ref;
        }
    }, true);
});


app.controller("EditInStudioModalController", function($scope, $stateParams, $state, DataikuAPI) {
    $scope.prompt = {};

    DataikuAPI.promptStudios.listHeads($stateParams.projectKey).then(function({data}) {
        $scope.promptStudios = data;
        $scope.promptStudios.unshift({createOption: true});

        if (!$scope.desc.associatedPromptStudioId) {
            $scope.overwriteDisabledReason = "The prompt recipe was not created from a prompt studio";
            $scope.prompt.create = true;
            return;
        }

        const originStudio = $scope.promptStudios.find(studio => studio.id === $scope.desc.associatedPromptStudioId);
        if (!originStudio) {
            $scope.overwriteDisabledReason = "The prompt studio from which the recipe was created is not available (probably deleted)";
            $scope.prompt.create = true;
            return;
        }

        $scope.prompt.studio = originStudio;
        $scope.originStudioName = originStudio.name;
        if (!originStudio.promptIds.includes($scope.desc.associatedPromptStudioPromptId)) {
            $scope.overwriteDisabledReason = "The prompt from which the recipe was created has been deleted from its prompt studio";
        }

        $scope.prompt.create = !!$scope.overwriteDisabledReason;
    }).catch(setErrorInScope.bind($scope));

    $scope.optionLabel = function(option) {
        if (option.createOption) {
            return "Create a new Prompt studio...";
        }
        return option.name;
    };

    $scope.editInStudio = function() {
        $scope.hooks.save().then(function() {
            const promptCreationSettings = {};
            if ($scope.prompt.studio.createOption) {
                promptCreationSettings.newPromptStudioName = $scope.prompt.studio.name;
            } else {
                promptCreationSettings.promptStudioId = $scope.prompt.studio.id;
                if (!$scope.prompt.create) {
                    promptCreationSettings.originPromptStudioPromptId = $scope.desc.associatedPromptStudioPromptId;
                }
            }

            DataikuAPI.promptStudios.editFromRecipe($stateParams.projectKey, $scope.recipe.name, promptCreationSettings).then(function({data}) {
                $state.go('projects.project.promptstudios.promptstudio', { promptStudioId: data.promptStudioId, promptId: data.promptStudioPromptId });
            }).catch(setErrorInScope.bind($scope));
        });
    };
});

}());
