(function() {
    'use strict';

    const app = angular.module('dataiku.directives.simple_report');

    /**
     * Controller handling sliders used by range filters.
     * (!) This controller previously was in static/dataiku/js/simple_report/chart_logic.js
     */
    app.controller('ChartSliderController', function($scope, $timeout) {
        $scope.slideEnd = function() {
            $timeout(function() {
                const filterData = $scope.filterTmpData[$scope.$index];
                const facetUiState = $scope.facetUiStates[$scope.$index];
                if (!filterData || !facetUiState) {
                    return;
                } // when a filter is added, you have to wait for the response from the backend before filterTmpData is here
                filterData.minValue = facetUiState.sliderModelMin;
                filterData.maxValue = facetUiState.sliderModelMax;
            });
        };
    });

})();
