(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This directive previously was in static/dataiku/js/simple_report/config_ui.js
    app.directive('multivaluedStdAggrMeasureZone', function($parse, ChartFeatures, ChartLabels, ChartCustomMeasures, ChartColorUtils) {
        return {
            templateUrl: '/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/multivalued-std-aggr-measure-zone/multivalued-std-aggr-measure-zone.directive.html',
            scope: true,
            link: function($scope, _element, attrs) {
                $scope.$watch(attrs.list, newList => $scope.list = newList);
                $scope.chartDefKey = attrs.chartDefKey;
                $scope.acceptCallback = $parse(attrs.acceptCallback)($scope);
                $scope.direction = attrs.direction;
                $scope.ChartFeatures = ChartFeatures;
                $scope.ChartLabels = ChartLabels;
                $scope.getAggregationFunctionDescription = ChartLabels.getAggregationFunctionDescription;
                $scope.countOfRecordsLabel = ChartLabels.COUNT_OF_RECORDS_LABEL;
                $scope.getAvailableAggregations = (measureType, chartType, contextualMenuMeasureType) => ChartLabels.getAvailableAggregationsLabels(measureType, chartType, contextualMenuMeasureType);
                $scope.getCustomMeasure = ChartCustomMeasures.getCustomMeasure;
                $scope.shouldDisplayMultiPlotDisplayMode = function(measure) {
                    return ChartFeatures.canSetMultiPlotDisplayMode($scope.chart.def.type) && measure && measure.displayType === 'line' && $scope.chart.def.genericMeasures.some(m => m.displayType === 'column') && !!ChartColorUtils.getColorDimensionOrMeasure($scope.chart.def);
                };
                $scope.assignToMeasure = function(data) {
                    _.set(data.measure, data.property, data.value);
                    if (!$scope.$$phase) {
                        $scope.$apply();
                    }
                };
                $scope.$watch(attrs.theme, (nv) => {
                    $scope.theme = nv;
                });
            }
        };
    });
})();
