(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('PieChart', PieChart);

    // (!) This service previously was in static/dataiku/js/simple_report/pies/pie.js
    function PieChart(ChartManager, ChartDataWrapperFactory, PieChartUtils, PieChartDrawer, ChartDimension) {
        return function($container, chartDef, chartHandler, axesDef, data) {
            const chartData = ChartDataWrapperFactory.chartTensorDataWrapper(data, axesDef);
            const animationData = PieChartUtils.prepareData(chartDef, chartData);
            const numberFormattingOptions = ChartDimension.getNumberFormattingOptions(chartDef.genericDimension0[0]);
            const drawFrame = function(frameIdx, chartBase) {
                animationData.frames[frameIdx].facets.forEach(function(facetData, f) {
                    const g = d3.select(chartBase.$svgs.eq(f).find('g.chart').get(0));
                    PieChartDrawer(g, chartDef, chartBase, facetData, numberFormattingOptions);
                });
            };

            ChartManager.initChart(chartDef, chartHandler, chartData, $container, drawFrame, null, { type: 'DIMENSION', name: 'color', dimension: chartDef.genericDimension0[0] });

        };
    }
})();
