(function () {
"use strict";

    angular.module("dataiku.nestedFilters").factory("FilterConditionsEditorService", FilterConditionsEditorService);

    function FilterConditionsEditorService(Logger, Expressions, FiltersService) {
        const filterConditionsEditorService = {
            getColumn,
            getColumnsExcept,
            update
        };

        function getColumn(scope, name) {
            return FiltersService.getColumns(scope).find(col => col.name === name);
        }

        function getColumnsExcept(scope, name) {
            return FiltersService.getColumns(scope).filter(col => col.name !== name);
        }

        function mapToAttr(arr, attr) {
            return arr.map(function(el){return el[attr];});
        }

        function update(scope, cond, fromPrepare) {
            cond.input = updateIfNotAllowed(cond.input, mapToAttr(FiltersService.getColumns(scope), 'name'), scope);
            cond.col = updateIfNotAllowed(cond.col, mapToAttr(getColumnsExcept(scope,cond.input), 'name'), scope);
            let col = getColumn(scope, cond.input);
            if (col) {
                let type = getColumn(scope,cond.input).type;
                if(!fromPrepare){
                    cond.operator = updateIfNotAllowed(
                        cond.operator,
                        mapToAttr(Expressions.getOperators(type), 'name'),
                        scope,
                        Expressions.getDefaultOperator(type)
                        );
                } else {
                    if (angular.isUndefined(cond.operator)) {
                        cond.operator = Expressions.getDefaultOperator(type) ? Expressions.getDefaultOperator(type) : mapToAttr(Expressions.getOperators(type), 'name')[0];
                    }
                    let operators = Expressions.getOperatorsPrepareRecipe();
                    operators.forEach(elt => {
                        if(elt.name == cond.operator) {
                            cond.$label = elt.label;
                            cond.$appliesTo = elt.appliesTo;
                        }
                    })
                }
            }
        }

        function updateIfNotAllowed(currentValue, allowedValues, scope, defaultValue) {
           if (!allowedValues || !allowedValues.length) {
               Logger.warn("WARNING: no allowedValues");
               return defaultValue;
           }
           if (allowedValues.indexOf(currentValue) > -1) return currentValue;
           if (defaultValue) return defaultValue;
           for (const value of allowedValues) {
               let col = getColumn(scope, value);
               if (col && col.type !== "date") {
                   return value;
               }

           }
           return allowedValues[0];
        }

        return filterConditionsEditorService;
    }
})();
