from .pyfunc_common import load_evaluation_dataset_sample
from .pyfunc_evaluate_model import run_model_evaluation
from .predictor import MLflowPredictor

from dataiku.external_ml.model_information_handler import PredictionExternalModelInformationHandler


class MLflowModelInformationHandler(PredictionExternalModelInformationHandler):

    def load_evaluation_dataset(self):
        return load_evaluation_dataset_sample(self._model_folder_context)

    def get_predictor(self):
        return MLflowPredictor(self._model_folder_context)

    def run_scoring(self, df, out_folder_context):
        run_model_evaluation(self._predictor.model, df, self._predictor.params, out_folder_context)
