import pandas as pd

from dataiku.external_ml.proxy_model.common import ProxyModel
from dataiku.external_ml.utils import convert_dataframe_to_records, \
    convert_prediction_response_to_dataframe
from dataikuapi import APINodeClient

import logging

logger = logging.getLogger(__name__)


class DSSProxyModel(ProxyModel):

    """DSS API node"""

    def __init__(self, root_url, service_id, endpoint_id, **kwargs):
        self.endpoint_id = endpoint_id
        self.client = APINodeClient(root_url, service_id)

    def predict(self, input_df):
        logger.info("Predicting using {} on input_df with shape {}".format(self.__class__.__name__, input_df.shape))
        records = convert_dataframe_to_records(input_df)
        response = self.client.predict_records(endpoint_id=self.endpoint_id, records=records)
        results = convert_prediction_response_to_dataframe(response)
        return pd.DataFrame(results)
