from tensorflow.keras.applications.imagenet_utils import preprocess_input
from dataiku.doctor.deep_learning.keras_utils import load_img

resized_width = 197
resized_height = 197

# Must return a numpy ndarray representing the image
#  - image_file is a file like object
def preprocess_image(image_file):
    # This will give you an input shape of (resized_height, resized_width, channels_number)
    # resized_dims - a tuple (width, height)
    # channels     -  'L', 'RGB' or 'CMYK'
    # data_format  - 'channels_last' or 'channels_first'
    array = load_img(image_file, resized_dims=(resized_width, resized_height), channels='RGB', data_format='channels_last')
    # Define the actual preprocessing here, for example:
    array = preprocess_input(array, mode='tf')
    return array
