from dataiku.project_standards import (
    ProjectStandardsCheckRunResult,
    ProjectStandardsCheckSpec,
)


class DatasetsProjectStandardsCheckSpec(ProjectStandardsCheckSpec):

    def run(self):
        """
        Run the check

        :returns: the check result
        """
        datasets = self.project.list_datasets()
        max_datasets = int(self.config.get("maxDatasets"))
        if len(datasets) > max_datasets:
            return ProjectStandardsCheckRunResult.failure(
                3,
                "Dataset count is {}, which exceeds the maximum count of {}.".format(len(datasets), max_datasets),
            )
        else:
            return ProjectStandardsCheckRunResult.success(
                "Dataset count is {}, which is within the maximum count of {}.".format(len(datasets), max_datasets)
            )
