from dataiku.project_standards import (
    ProjectStandardsCheckRunResult,
    ProjectStandardsCheckSpec,
)


class ProjectDescriptionCheckSpec(ProjectStandardsCheckSpec):

    def run(self):
        metadata = self.project.get_metadata()
        description = metadata.get("description", "")
        short_description = metadata.get("shortDesc", "")
        if len(description) == 0:
            return ProjectStandardsCheckRunResult.failure(3, "The long description of the project is missing")
        elif len(short_description) == 0:
            return ProjectStandardsCheckRunResult.failure(3, "The short description of the project is missing")
        else:
            return ProjectStandardsCheckRunResult.success("Project has a short and a long description")
