#' Upload data for a path in a folder
#'
#' @param name the name of the folder
#' @param path the subpath in the folder where the data should be stored
#' @param data a connection providing the data to upload
#' @return None
#'
#' @export
#' @importFrom httr POST

library(utils)

dkuManagedFolderUploadPath <- function(name, path, data) {
    dipHome = dku_remoterun__get_env_var("DIP_HOME")
    if(is.null(dipHome) || dipHome=="") {
      stop("DIP_HOME isn't defined")
    }

    getPathURL = dku_intercom__get_jek_or_backend_url("/managed-folders/upload-path")
    ref = dku__resolve_smart_name(name)

    tmpFilePath <- tempfile(pattern='r-managedfolder-upload-')
    file.create(tmpFilePath)
    tmpFileConn <- file(tmpFilePath, "wb")
    cat("Start writing data to temp file for upload ...\n")
	while (length(a <- readBin(data, raw(), n=10000)) > 0) {
	    writeBin(a, tmpFileConn)
	}
    cat("Done writing data to temp file ...\n")
    close(tmpFileConn)

    # encode the parameters in the url because we want to send the file in the body
    encodedPathURL <- paste0(getPathURL, "?projectKey=", URLencode(dku__ref_to_pkey(ref), reserved=TRUE), "&lookup=", URLencode(dku__ref_to_name(ref), reserved=TRUE), "&path=", URLencode(path, reserved=TRUE))
    resp = POST(encodedPathURL, body = upload_file(tmpFilePath), dku__get_auth_headers(), dku_intercom__get_httr_config())

    # Drop the temp file
    unlink(tmpFilePath)

    dku__check_api_error(resp, "Failed to upload Box path")
}
