% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insights.R
\name{dkuSaveGgvisInsight}
\alias{dkuSaveGgvisInsight}
\title{Saves a ggvis chart as a DSS static insight that can be exposed on the dashboard}
\usage{
dkuSaveGgvisInsight(id, gg, label = NULL)
}
\arguments{
\item{id:}{Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced}

\item{gg:}{the ggvis chart}

\item{label:}{Optional display label for the insight. If NULL, the id will be used as label}
}
\value{
Nothing
}
\description{
Saves a ggvis chart as a DSS static insight that can be exposed on the dashboard
}
\examples{
\dontrun{
# Prepare the chart
chart <- mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_points()

# Save it as an insight
dkuSaveGgvisInsight("my-ggvis-plot", chart)
}
}
