/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jodd.util.DateFormatSymbolsEx;
import jodd.util.StringUtil;

public class LocaleUtil {
    protected static Map<String, LocaleData> locales = new HashMap<String, LocaleData>();

    protected static LocaleData lookupLocaleData(String code) {
        LocaleData localeData = locales.get(code);
        if (localeData == null) {
            String[] data = LocaleUtil.decodeLocaleCode(code);
            localeData = new LocaleData(new Locale(data[0], data[1], data[2]));
            locales.put(code, localeData);
        }
        return localeData;
    }

    protected static LocaleData lookupLocaleData(Locale locale) {
        return LocaleUtil.lookupLocaleData(LocaleUtil.resolveLocaleCode(locale));
    }

    public static Locale getLocale(String language, String country, String variant) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(LocaleUtil.resolveLocaleCode(language, country, variant));
        return localeData.locale;
    }

    public static Locale getLocale(String language, String country) {
        return LocaleUtil.getLocale(language, country, null);
    }

    public static Locale getLocale(String languageCode) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(languageCode);
        return localeData.locale;
    }

    public static String resolveLocaleCode(String lang, String country, String variant) {
        StringBuilder code = new StringBuilder(lang);
        if (!StringUtil.isEmpty(country)) {
            code.append('_').append(country);
            if (!StringUtil.isEmpty(variant)) {
                code.append('_').append(variant);
            }
        }
        return code.toString();
    }

    public static String resolveLocaleCode(Locale locale) {
        return LocaleUtil.resolveLocaleCode(locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static String[] decodeLocaleCode(String localeCode) {
        String[] result = new String[3];
        String[] data = StringUtil.splitc(localeCode, '_');
        result[0] = data[0];
        result[2] = "";
        result[1] = "";
        if (data.length >= 2) {
            result[1] = data[1];
            if (data.length >= 3) {
                result[2] = data[2];
            }
        }
        return result;
    }

    public static DateFormatSymbolsEx getDateFormatSymbols(Locale locale) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(locale);
        DateFormatSymbolsEx dfs = localeData.dateFormatSymbols;
        if (dfs == null) {
            localeData.dateFormatSymbols = dfs = new DateFormatSymbolsEx(locale);
        }
        return dfs;
    }

    public static NumberFormat getNumberFormat(Locale locale) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(locale);
        NumberFormat nf = localeData.numberFormat;
        if (nf == null) {
            localeData.numberFormat = nf = NumberFormat.getInstance(locale);
        }
        return nf;
    }

    static class LocaleData {
        final Locale locale;
        DateFormatSymbolsEx dateFormatSymbols;
        NumberFormat numberFormat;

        LocaleData(Locale locale) {
            this.locale = locale;
        }
    }
}

