/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FieldNode {
    private String fieldName;
    private List<FieldNode> nodes;

    public FieldNode(String fieldName) {
        this.fieldName = fieldName;
        this.nodes = new ArrayList<FieldNode>();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void addFieldNodes(FieldNode ... nodes) {
        if (nodes != null) {
            this.addFieldNodes(Arrays.asList(nodes));
        }
    }

    public void addFieldNodes(List<FieldNode> nodes) {
        for (FieldNode fn : nodes) {
            if (fn == null) continue;
            this.nodes.add(fn);
        }
    }

    public List<FieldNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<FieldNode> nodes) {
        this.nodes = nodes;
    }

    public List<String> toPaths() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.nodes.isEmpty()) {
            result.add(this.fieldName);
        } else {
            for (FieldNode child : this.nodes) {
                for (String rest : child.toPaths()) {
                    result.add(this.fieldName + "." + rest);
                }
            }
        }
        return result;
    }

    public static FieldNode fromPath(String path) {
        String[] parts = path.split("\\.");
        return FieldNode.fromPath(parts, 0);
    }

    private static FieldNode fromPath(String[] parts, int index) {
        if (index == parts.length) {
            return null;
        }
        FieldNode fn = new FieldNode(parts[index]);
        fn.addFieldNodes(FieldNode.fromPath(parts, index + 1));
        return fn;
    }

    public static List<FieldNode> mergeFieldNodes(List<FieldNode> nodes, FieldNode fn) {
        ArrayList<FieldNode> result = new ArrayList<FieldNode>(nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            FieldNode mfn = FieldNode.mergeFieldNode(nodes.get(i), fn);
            if (mfn == null) continue;
            result.set(i, mfn);
            return result;
        }
        result.add(fn);
        return result;
    }

    public static List<FieldNode> mergeFieldNodes(List<FieldNode> left, List<FieldNode> right) {
        List<FieldNode> result = new ArrayList<FieldNode>(left);
        for (FieldNode fn : right) {
            result = FieldNode.mergeFieldNodes(result, fn);
        }
        return result;
    }

    public static FieldNode mergeFieldNode(FieldNode left, FieldNode right) {
        Preconditions.checkArgument(left.getFieldName() != null && right.getFieldName() != null);
        if (!left.getFieldName().equals(right.getFieldName())) {
            return null;
        }
        if (left.getNodes().isEmpty()) {
            return left;
        }
        if (right.getNodes().isEmpty()) {
            return right;
        }
        FieldNode result = new FieldNode(left.getFieldName());
        result.setNodes(FieldNode.mergeFieldNodes(left.getNodes(), right.getNodes()));
        return result;
    }

    public String toString() {
        String res = this.fieldName;
        if (this.nodes.size() > 0) {
            res = res + "[";
            for (int i = 0; i < this.nodes.size(); ++i) {
                res = i == this.nodes.size() - 1 ? res + this.nodes.get(i).toString() : res + this.nodes.get(i).toString() + ",";
            }
            res = res + "]";
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldNode fieldNode = (FieldNode)o;
        if (this.fieldName != null ? !this.fieldName.equals(fieldNode.fieldName) : fieldNode.fieldName != null) {
            return false;
        }
        return this.nodes != null ? this.nodes.equals(fieldNode.nodes) : fieldNode.nodes == null;
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.nodes != null ? this.nodes.hashCode() : 0);
        return result;
    }
}

