/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc;

import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.SqlDialect;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.JdbcHiveTableScan;

public class HiveJdbcConverter
extends ConverterImpl
implements HiveRelNode {
    private final JdbcConvention convention;

    public HiveJdbcConverter(RelOptCluster cluster, RelTraitSet traits, JdbcRel input, JdbcConvention jc) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, (RelNode)input);
        this.convention = jc;
    }

    private HiveJdbcConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input, JdbcConvention jc) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
        this.convention = jc;
    }

    public JdbcConvention getJdbcConvention() {
        return this.convention;
    }

    public SqlDialect getJdbcDialect() {
        return this.convention.dialect;
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HiveJdbcConverter(this.getCluster(), traitSet, (RelNode)HiveJdbcConverter.sole(inputs), this.convention);
    }

    public String generateSql() {
        SqlDialect dialect = this.getJdbcDialect();
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitChild(0, this.getInput());
        return result.asStatement().toSqlString(dialect).getSql();
    }

    public JdbcHiveTableScan getTableScan() {
        final JdbcHiveTableScan[] tmpJdbcHiveTableScan = new JdbcHiveTableScan[1];
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof JdbcHiveTableScan && tmpJdbcHiveTableScan[0] == null) {
                    tmpJdbcHiveTableScan[0] = (JdbcHiveTableScan)node;
                } else {
                    super.visit(node, ordinal, parent);
                }
            }
        }.go((RelNode)this);
        JdbcHiveTableScan jdbcHiveTableScan = tmpJdbcHiveTableScan[0];
        assert (jdbcHiveTableScan != null);
        return jdbcHiveTableScan;
    }
}

