/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.security.authorization.PolicyProviderContainer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegeSynchonizer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PrivilegeSynchonizer.class);
    public static final String GRANTOR = "ranger";
    private IMetaStoreClient hiveClient;
    private LeaderLatch privilegeSynchonizerLatch;
    private HiveConf hiveConf;
    private PolicyProviderContainer policyProviderContainer;

    public PrivilegeSynchonizer(LeaderLatch privilegeSynchonizerLatch, PolicyProviderContainer policyProviderContainer, HiveConf hiveConf) {
        this.hiveConf = new HiveConf(hiveConf);
        this.hiveConf.set(MetastoreConf.ConfVars.FILTER_HOOK.getVarname(), DefaultMetaStoreFilterHookImpl.class.getName());
        try {
            this.hiveClient = Hive.get(this.hiveConf).getMSC();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating HiveMetastoreClient", e);
        }
        this.privilegeSynchonizerLatch = privilegeSynchonizerLatch;
        this.policyProviderContainer = policyProviderContainer;
        this.hiveConf = hiveConf;
    }

    private void addACLsToBag(Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> principalAclsMap, PrivilegeBag privBag, HiveObjectType objectType, String dbName, String tblName, String columnName, PrincipalType principalType, String authorizer) {
        for (Map.Entry<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> principalAcls : principalAclsMap.entrySet()) {
            String principal = principalAcls.getKey();
            block6: for (Map.Entry<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> acl : principalAcls.getValue().entrySet()) {
                if (acl.getValue() != HiveResourceACLs.AccessResult.ALLOWED) continue;
                switch (objectType) {
                    case DATABASE: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false), authorizer));
                        continue block6;
                    }
                    case TABLE: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tblName, null, null), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false), authorizer));
                        continue block6;
                    }
                    case COLUMN: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.COLUMN, dbName, tblName, null, columnName), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false), authorizer));
                        continue block6;
                    }
                }
                throw new RuntimeException("Get unknown object type " + objectType);
            }
        }
    }

    private HiveObjectRef getObjToRefresh(HiveObjectType type, String dbName, String tblName) throws Exception {
        HiveObjectRef objToRefresh = null;
        switch (type) {
            case DATABASE: {
                objToRefresh = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
                break;
            }
            case TABLE: {
                objToRefresh = new HiveObjectRef(HiveObjectType.TABLE, dbName, tblName, null, null);
                break;
            }
            case COLUMN: {
                objToRefresh = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tblName, null, null);
                break;
            }
            default: {
                throw new RuntimeException("Get unknown object type " + type);
            }
        }
        return objToRefresh;
    }

    private void addGrantPrivilegesToBag(HivePolicyProvider policyProvider, PrivilegeBag privBag, HiveObjectType type, String dbName, String tblName, String columnName, String authorizer) throws Exception {
        HiveResourceACLs objectAcls = null;
        switch (type) {
            case DATABASE: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, dbName, null));
                break;
            }
            case TABLE: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tblName));
                break;
            }
            case COLUMN: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.COLUMN, dbName, tblName, null, columnName));
                break;
            }
            default: {
                throw new RuntimeException("Get unknown object type " + type);
            }
        }
        if (objectAcls == null) {
            return;
        }
        this.addACLsToBag(objectAcls.getUserPermissions(), privBag, type, dbName, tblName, columnName, PrincipalType.USER, authorizer);
        this.addACLsToBag(objectAcls.getGroupPermissions(), privBag, type, dbName, tblName, columnName, PrincipalType.GROUP, authorizer);
    }

    @Override
    public void run() {
        while (true) {
            long interval = HiveConf.getTimeVar(this.hiveConf, HiveConf.ConfVars.HIVE_PRIVILEGE_SYNCHRONIZER_INTERVAL, TimeUnit.SECONDS);
            try {
                for (HivePolicyProvider policyProvider : this.policyProviderContainer) {
                    String authorizer = policyProvider.getClass().getSimpleName();
                    if (!this.privilegeSynchonizerLatch.await(interval, TimeUnit.SECONDS)) continue;
                    LOG.info("Start synchonize privilege");
                    for (String dbName : this.hiveClient.getAllDatabases()) {
                        HiveObjectRef dbToRefresh = this.getObjToRefresh(HiveObjectType.DATABASE, dbName, null);
                        PrivilegeBag grantDatabaseBag = new PrivilegeBag();
                        this.addGrantPrivilegesToBag(policyProvider, grantDatabaseBag, HiveObjectType.DATABASE, dbName, null, null, authorizer);
                        this.hiveClient.refresh_privileges(dbToRefresh, authorizer, grantDatabaseBag);
                        for (String tblName : this.hiveClient.getAllTables(dbName)) {
                            HiveObjectRef tableToRefresh = this.getObjToRefresh(HiveObjectType.TABLE, dbName, tblName);
                            PrivilegeBag grantTableBag = new PrivilegeBag();
                            this.addGrantPrivilegesToBag(policyProvider, grantTableBag, HiveObjectType.TABLE, dbName, tblName, null, authorizer);
                            this.hiveClient.refresh_privileges(tableToRefresh, authorizer, grantTableBag);
                            HiveObjectRef tableOfColumnsToRefresh = this.getObjToRefresh(HiveObjectType.COLUMN, dbName, tblName);
                            PrivilegeBag grantColumnBag = new PrivilegeBag();
                            Table tbl = this.hiveClient.getTable(dbName, tblName);
                            for (FieldSchema fs : tbl.getPartitionKeys()) {
                                this.addGrantPrivilegesToBag(policyProvider, grantColumnBag, HiveObjectType.COLUMN, dbName, tblName, fs.getName(), authorizer);
                            }
                            for (FieldSchema fs : tbl.getSd().getCols()) {
                                this.addGrantPrivilegesToBag(policyProvider, grantColumnBag, HiveObjectType.COLUMN, dbName, tblName, fs.getName(), authorizer);
                            }
                            this.hiveClient.refresh_privileges(tableOfColumnsToRefresh, authorizer, grantColumnBag);
                        }
                    }
                }
                Thread.sleep(interval * 1000L);
                LOG.info("Success synchonize privilege");
                continue;
            }
            catch (Exception e) {
                LOG.error("Error initializing PrivilegeSynchonizer: " + e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }
}

