/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ComposeObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StartResumableWriteRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectSpec;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

class GoogleCloudStorageClientGrpcDownscopingInterceptor
implements ClientInterceptor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    @VisibleForTesting
    static final String GOOGLE_STORAGE_V_2_STORAGE_COMPOSE_OBJECT = "google.storage.v2.Storage/ComposeObject";
    @VisibleForTesting
    static final String GOOGLE_STORAGE_V_2_STORAGE_DELETE_OBJECT = "google.storage.v2.Storage/DeleteObject";
    @VisibleForTesting
    static final String GOOGLE_STORAGE_V_2_STORAGE_READ_OBJECT = "google.storage.v2.Storage/ReadObject";
    @VisibleForTesting
    static final String GOOGLE_STORAGE_V_2_STORAGE_START_RESUMABLE_WRITE = "google.storage.v2.Storage/StartResumableWrite";
    @VisibleForTesting
    static final String GOOGLE_STORAGE_V_2_STORAGE_WRITE_OBJECT = "google.storage.v2.Storage/WriteObject";
    @VisibleForTesting
    private static final int BUCKET_PREFIX_LENGTH = "projects/_/buckets/".length();
    @VisibleForTesting
    static Metadata.Key<String> AUTH_KEY = Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER);
    private final Function<List<AccessBoundary>, String> downscopingFunction;

    public GoogleCloudStorageClientGrpcDownscopingInterceptor(Function<List<AccessBoundary>, String> downscopedAccessToken) {
        this.downscopingFunction = downscopedAccessToken;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ((GoogleLogger.Api)logger.atFinest()).log(String.format("interceptCall(): method=%s", method.getFullMethodName()));
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            private int flowControlRequests;
            private final String methodName;
            private Metadata headers;
            private ClientCall.Listener<RespT> responseListener;
            {
                super(x0);
                this.methodName = method.getFullMethodName();
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                this.responseListener = responseListener;
                this.headers = headers;
                ((GoogleLogger.Api)logger.atFinest()).log("start(): method=%s", this.methodName);
            }

            @Override
            public void request(int numMessages) {
                if (this.headers != null) {
                    this.flowControlRequests += numMessages;
                } else {
                    super.request(numMessages);
                }
            }

            @Override
            public void sendMessage(ReqT message) {
                if (this.headers != null) {
                    this.setAuthHeader(message);
                    super.start(this.responseListener, this.headers);
                    this.headers = null;
                    if (this.flowControlRequests != 0) {
                        super.request(this.flowControlRequests);
                        this.flowControlRequests = 0;
                    }
                }
                super.sendMessage(message);
            }

            private void setAuthHeader(ReqT message) {
                if (this.headers == null) {
                    return;
                }
                String token = this.getDownScopedToken(message);
                if (token != null) {
                    ((GoogleLogger.Api)logger.atFinest()).log("Setting down-scoped auth token");
                    this.headers.put(AUTH_KEY, "Bearer " + token);
                }
            }

            private String getDownScopedToken(ReqT message) {
                List<AccessBoundary> accessBoundaries = this.getAccessBoundaries(message);
                return this.getDownscopedToken(accessBoundaries);
            }

            private String getBucketName(String bucketLongName) {
                return bucketLongName.substring(BUCKET_PREFIX_LENGTH);
            }

            private List<AccessBoundary> getAccessBoundaries(ReqT message) {
                if (GoogleCloudStorageClientGrpcDownscopingInterceptor.GOOGLE_STORAGE_V_2_STORAGE_READ_OBJECT.equals(this.methodName)) {
                    ReadObjectRequest readObjectRequest = (ReadObjectRequest)message;
                    String bucketName = this.getBucketName(readObjectRequest.getBucket());
                    String objectName = readObjectRequest.getObject();
                    return ImmutableList.of(AccessBoundary.create(bucketName, objectName, AccessBoundary.Action.READ_OBJECTS));
                }
                if (GoogleCloudStorageClientGrpcDownscopingInterceptor.GOOGLE_STORAGE_V_2_STORAGE_WRITE_OBJECT.equals(this.methodName)) {
                    WriteObjectSpec writeObjectSpec = ((WriteObjectRequest)message).getWriteObjectSpec();
                    com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object obj = writeObjectSpec.getResource();
                    String theBucket = obj.getBucket();
                    if (theBucket == null || theBucket.length() == 0) {
                        return ImmutableList.of();
                    }
                    return ImmutableList.of(AccessBoundary.create(this.getBucketName(theBucket), obj.getName(), AccessBoundary.Action.WRITE_OBJECTS));
                }
                if (GoogleCloudStorageClientGrpcDownscopingInterceptor.GOOGLE_STORAGE_V_2_STORAGE_DELETE_OBJECT.equals(this.methodName)) {
                    DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)message;
                    return ImmutableList.of(AccessBoundary.create(this.getBucketName(deleteObjectRequest.getBucket()), deleteObjectRequest.getObject(), AccessBoundary.Action.DELETE_OBJECTS));
                }
                if (GoogleCloudStorageClientGrpcDownscopingInterceptor.GOOGLE_STORAGE_V_2_STORAGE_START_RESUMABLE_WRITE.equals(this.methodName)) {
                    com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object obj = ((StartResumableWriteRequest)message).getWriteObjectSpec().getResource();
                    AccessBoundary accessBoundary = AccessBoundary.create(this.getBucketName(obj.getBucket()), obj.getName(), AccessBoundary.Action.WRITE_OBJECTS);
                    return ImmutableList.of(accessBoundary);
                }
                if (GoogleCloudStorageClientGrpcDownscopingInterceptor.GOOGLE_STORAGE_V_2_STORAGE_COMPOSE_OBJECT.equals(this.methodName)) {
                    ComposeObjectRequest composeObjectRequest = (ComposeObjectRequest)message;
                    com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object dest = composeObjectRequest.getDestination();
                    List<ComposeObjectRequest.SourceObject> sourceObjects = composeObjectRequest.getSourceObjectsList();
                    String bucketName = this.getBucketName(dest.getBucket());
                    ArrayList<AccessBoundary> accessBoundaries = new ArrayList<AccessBoundary>(sourceObjects.size() + 1);
                    accessBoundaries.add(AccessBoundary.create(bucketName, dest.getName(), AccessBoundary.Action.WRITE_OBJECTS));
                    for (ComposeObjectRequest.SourceObject so : sourceObjects) {
                        accessBoundaries.add(AccessBoundary.create(bucketName, so.getName(), AccessBoundary.Action.READ_OBJECTS));
                    }
                    return accessBoundaries;
                }
                ((GoogleLogger.Api)logger.atSevere()).log("Unexpected method `%s`", this.methodName);
                return ImmutableList.of();
            }

            private String getDownscopedToken(List<AccessBoundary> accessBoundaries) {
                ((GoogleLogger.Api)logger.atFinest()).log("Getting downscoped token for %s; method=%s", accessBoundaries, (Object)this.methodName);
                if (accessBoundaries.size() == 0) {
                    return null;
                }
                try {
                    return (String)GoogleCloudStorageClientGrpcDownscopingInterceptor.this.downscopingFunction.apply(accessBoundaries);
                }
                catch (Throwable e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Getting down-scoped token failed. details=%s", e.getMessage());
                    throw e;
                }
            }
        };
    }
}

