/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BucketInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Utils;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BackwardCompatibilityUtils {
    static final Conversions.Codec<@Nullable Long, @Nullable OffsetDateTime> millisOffsetDateTimeCodec = Conversions.Codec.of(l -> Instant.ofEpochMilli(Objects.requireNonNull(l, "l must be non null")).atOffset(ZoneOffset.systemDefault().getRules().getOffset(Instant.now())), odt -> Objects.requireNonNull(odt, "odt must be non null").toInstant().toEpochMilli()).nullable();
    static final Conversions.Codec<Long, OffsetDateTime> millisUtcCodec = Conversions.Codec.of(l -> Instant.ofEpochMilli(Objects.requireNonNull(l, "l must be non null")).atOffset(ZoneOffset.UTC), odt -> Objects.requireNonNull(odt, "odt must be non null").toInstant().toEpochMilli());
    static final Conversions.Codec<@Nullable Duration, @Nullable Long> nullableDurationSecondsCodec = Utils.durationSecondsCodec.nullable();
    static final Conversions.Codec<BucketInfo.DeleteRule, BucketInfo.LifecycleRule> deleteRuleCodec = Conversions.Codec.of(BackwardCompatibilityUtils::deleteRuleEncode, BackwardCompatibilityUtils::deleteRuleDecode);

    private BackwardCompatibilityUtils() {
    }

    private static BucketInfo.LifecycleRule deleteRuleEncode(BucketInfo.DeleteRule from) {
        if (from instanceof BucketInfo.RawDeleteRule) {
            BucketInfo.RawDeleteRule raw = (BucketInfo.RawDeleteRule)from;
            Bucket.Lifecycle.Rule rule = raw.getRule();
            String msg = "The lifecycle condition " + BackwardCompatibilityUtils.resolveRuleActionType(from) + " is not currently supported. Please update to the latest version of google-cloud-java. Also, use LifecycleRule rather than the deprecated DeleteRule.";
            LogRecord record = new LogRecord(Level.WARNING, msg);
            record.setLoggerName(BucketInfo.RawDeleteRule.class.getName());
            record.setSourceClassName(BucketInfo.RawDeleteRule.class.getName());
            record.setSourceMethodName("populateCondition");
            BucketInfo.log.log(record);
            BucketInfo.LifecycleRule.LifecycleCondition condition = (BucketInfo.LifecycleRule.LifecycleCondition)Conversions.json().lifecycleCondition().decode(rule.getCondition());
            return new BucketInfo.LifecycleRule(BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction(), condition);
        }
        BucketInfo.LifecycleRule.LifecycleCondition.Builder condition = BucketInfo.LifecycleRule.LifecycleCondition.newBuilder();
        if (from instanceof BucketInfo.CreatedBeforeDeleteRule) {
            BucketInfo.CreatedBeforeDeleteRule r = (BucketInfo.CreatedBeforeDeleteRule)from;
            condition.setCreatedBeforeOffsetDateTime(r.getTime());
        } else if (from instanceof BucketInfo.AgeDeleteRule) {
            BucketInfo.AgeDeleteRule r = (BucketInfo.AgeDeleteRule)from;
            condition.setAge(r.getDaysToLive());
        } else if (from instanceof BucketInfo.NumNewerVersionsDeleteRule) {
            BucketInfo.NumNewerVersionsDeleteRule r = (BucketInfo.NumNewerVersionsDeleteRule)from;
            condition.setNumberOfNewerVersions(r.getNumNewerVersions());
        } else if (from instanceof BucketInfo.IsLiveDeleteRule) {
            BucketInfo.IsLiveDeleteRule r = (BucketInfo.IsLiveDeleteRule)from;
            condition.setIsLive(r.isLive());
        }
        return new BucketInfo.LifecycleRule(BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction(), condition.build());
    }

    private static BucketInfo.DeleteRule deleteRuleDecode(BucketInfo.LifecycleRule from) {
        if (from.getAction() != null && "Delete".endsWith(BackwardCompatibilityUtils.resolveRuleActionType(from))) {
            BucketInfo.LifecycleRule.LifecycleCondition condition = from.getCondition();
            Integer age = condition.getAge();
            if (age != null) {
                return new BucketInfo.AgeDeleteRule(age);
            }
            OffsetDateTime createdBefore = condition.getCreatedBeforeOffsetDateTime();
            if (createdBefore != null) {
                return new BucketInfo.CreatedBeforeDeleteRule(createdBefore);
            }
            Integer numNewerVersions = condition.getNumberOfNewerVersions();
            if (numNewerVersions != null) {
                return new BucketInfo.NumNewerVersionsDeleteRule(numNewerVersions);
            }
            Boolean isLive = condition.getIsLive();
            if (isLive != null) {
                return new BucketInfo.IsLiveDeleteRule(isLive);
            }
        }
        return new BucketInfo.RawDeleteRule((Bucket.Lifecycle.Rule)Conversions.json().lifecycleRule().encode(from));
    }

    private static String resolveRuleActionType(BucketInfo.DeleteRule deleteRule) {
        if (deleteRule != null && deleteRule.getType() != null) {
            return deleteRule.getType().name();
        }
        return null;
    }

    private static String resolveRuleActionType(BucketInfo.LifecycleRule rule) {
        if (rule != null && rule.getAction() != null) {
            return rule.getAction().getActionType();
        }
        return null;
    }
}

