/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Bootstrapper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.EnvoyServerProtoData;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.CommonTlsContextUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.ReferenceCountingMap;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.SslContextProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.certprovider.CertProviderServerSslContextProviderFactory;

final class ServerSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderServerSslContextProviderFactory certProviderServerSslContextProviderFactory;

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderServerSslContextProviderFactory.getInstance());
    }

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderServerSslContextProviderFactory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderServerSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull(downstreamTlsContext, "downstreamTlsContext");
        Preconditions.checkNotNull(downstreamTlsContext.getCommonTlsContext(), "downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(downstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderServerSslContextProviderFactory.getProvider(downstreamTlsContext, this.bootstrapInfo.node().toEnvoyProtoNode(), this.bootstrapInfo.certProviders());
        }
        throw new UnsupportedOperationException("Unsupported configurations in DownstreamTlsContext!");
    }
}

