/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig.summary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EnumStat {
    private static final int MAX_COUNT = 1000;
    private Map<String, EnumValueCount> values = new HashMap<String, EnumValueCount>();

    public void add(String value) {
        if (this.values != null) {
            EnumValueCount enumValueCount = this.values.get(value);
            if (enumValueCount == null) {
                enumValueCount = new EnumValueCount(value);
                this.values.put(value, enumValueCount);
            }
            enumValueCount.add();
            this.checkValues();
        }
    }

    public void merge(EnumStat other) {
        if (this.values != null) {
            if (other.values == null) {
                this.values = null;
                return;
            }
            for (EnumValueCount otherValue : other.getValues()) {
                EnumValueCount myValue = this.values.get(otherValue.value);
                if (myValue == null) {
                    this.values.put(otherValue.value, otherValue);
                    continue;
                }
                myValue.add(otherValue.count);
            }
            this.checkValues();
        }
    }

    private void checkValues() {
        if (this.values.size() > 1000) {
            this.values = null;
        }
    }

    public Collection<EnumValueCount> getValues() {
        return this.values == null ? null : this.values.values();
    }

    public void setValues(Collection<EnumValueCount> values) {
        if (values == null) {
            this.values = null;
        } else if (this.values != null) {
            for (EnumValueCount value : values) {
                this.values.put(value.getValue(), value);
            }
        }
    }

    public static class EnumValueCount {
        private String value;
        private int count;

        public EnumValueCount() {
        }

        public EnumValueCount(String value) {
            this.value = value;
        }

        public void add() {
            ++this.count;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void add(int countToAdd) {
            this.count += countToAdd;
        }
    }
}

