/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.maths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

public class PrefixSumMovingAverage {
    private int windowSize = 0;
    private double diviseur = 0.0;
    private int position = 0;
    private ArrayList<PrefixSumEntry> entries;

    public void reset() {
        this.windowSize = 0;
        this.diviseur = 0.0;
        this.position = 0;
        this.entries = null;
    }

    public boolean isReady() {
        return this.windowSize > 0;
    }

    public void allocate(int window_size, double d, int p) {
        this.windowSize = window_size;
        this.diviseur = d;
        this.entries = new ArrayList();
        this.position = p;
    }

    public double getDiviseur() {
        return this.diviseur;
    }

    public double getPosition() {
        return this.position;
    }

    public void merge(List<DoubleWritable> other) {
        double movingAverage;
        PrefixSumEntry e;
        int i;
        if (other == null) {
            return;
        }
        if (this.windowSize == 0) {
            this.windowSize = (int)other.get(0).get();
            this.diviseur = other.get(1).get();
            this.position = (int)other.get(2).get();
            this.entries = new ArrayList();
            for (i = 3; i < other.size(); i += 2) {
                e = new PrefixSumEntry();
                e.period = (int)other.get(i).get();
                e.value = other.get(i + 1).get();
                this.entries.add(e);
            }
        } else {
            for (i = 3; i < other.size(); i += 2) {
                e = new PrefixSumEntry();
                e.period = (int)other.get(i).get();
                e.value = other.get(i + 1).get();
                this.entries.add(e);
            }
        }
        Collections.sort(this.entries);
        double[] listCoeff = new double[this.windowSize];
        double subdenom = 0.0;
        double coeffPond = 0.0;
        for (int i2 = 1; i2 <= this.windowSize; ++i2) {
            listCoeff[i2 - 1] = coeffPond = 1.0 / Math.pow(this.getDiviseur(), i2);
            subdenom += coeffPond;
        }
        int lastEntry = this.entries.size() - 1;
        double prefixSum = 0.0;
        int variationPos = 0;
        for (int j = 0; j < this.windowSize; ++j) {
            if (lastEntry - variationPos >= 0) {
                PrefixSumEntry thisEntry = this.entries.get(lastEntry - variationPos);
                while ((double)thisEntry.period > this.getPosition() - (double)j) {
                    thisEntry = this.entries.get(lastEntry - ++variationPos);
                }
                if ((double)thisEntry.period == this.getPosition() - (double)j) {
                    prefixSum += thisEntry.value * listCoeff[j];
                    ++variationPos;
                    continue;
                }
                prefixSum += 0.0 * listCoeff[j];
                continue;
            }
            prefixSum += 0.0 * listCoeff[j];
        }
        PrefixSumEntry thisEntry = this.entries.get(lastEntry);
        thisEntry.movingAverage = movingAverage = prefixSum / subdenom;
    }

    public int tableSize() {
        return this.entries.size();
    }

    public PrefixSumEntry getEntry(int index) {
        return this.entries.get(index);
    }

    private boolean needsSorting(ArrayList<PrefixSumEntry> entries) {
        Object previous = null;
        for (PrefixSumEntry current : entries) {
            if (previous == null || current.compareTo((Object)previous) >= 0) continue;
            return true;
        }
        return false;
    }

    public void add(int period, double v) {
        PrefixSumEntry e = new PrefixSumEntry();
        e.period = period;
        e.value = v;
        this.entries.add(e);
        Collections.sort(this.entries);
    }

    public ArrayList<DoubleWritable> serialize() {
        ArrayList<DoubleWritable> result = new ArrayList<DoubleWritable>();
        result.add(new DoubleWritable((double)this.windowSize));
        result.add(new DoubleWritable(this.diviseur));
        result.add(new DoubleWritable((double)this.position));
        if (this.entries != null) {
            for (PrefixSumEntry i : this.entries) {
                result.add(new DoubleWritable((double)i.period));
                result.add(new DoubleWritable(i.value));
            }
        }
        return result;
    }

    static class PrefixSumEntry
    implements Comparable {
        int period;
        double value;
        double prefixSum;
        double subsequenceTotal;
        double movingAverage;

        PrefixSumEntry() {
        }

        public int compareTo(Object other) {
            PrefixSumEntry o = (PrefixSumEntry)other;
            if (this.period < o.period) {
                return -1;
            }
            if (this.period > o.period) {
                return 1;
            }
            return 0;
        }
    }
}

