/*
 * Decompiled with CFR 0.152.
 */
package jupyter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jupyter.Displayer;
import jupyter.ToStringDisplayer;

public class Registration {
    static final Registration INSTANCE = new Registration();
    private final Map<Class<?>, Displayer<?>> displayers = new HashMap();
    private Displayer<Object> defaultDisplayer = ToStringDisplayer.get();
    private String[] mimeTypes = null;

    public Map<Class<?>, Displayer<?>> getAll() {
        return Collections.unmodifiableMap(this.displayers);
    }

    public void setMimeTypes(String ... types) {
        this.mimeTypes = types;
        for (Displayer<?> displayer : this.displayers.values()) {
            displayer.setMimeTypes(types);
        }
        this.defaultDisplayer.setMimeTypes(types);
    }

    public void setDefault(Displayer<Object> displayer) {
        this.defaultDisplayer = displayer;
    }

    public <T> void add(Class<T> objClass, Displayer<T> displayer) {
        if (this.mimeTypes != null) {
            displayer.setMimeTypes(this.mimeTypes);
        }
        this.displayers.put(objClass, displayer);
    }

    public <T> Displayer<? super T> find(Class<T> objClass) {
        for (Class<T> currentClass = objClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Displayer<?> displayer = this.displayers.get(currentClass);
            if (displayer == null) continue;
            return displayer;
        }
        return this.defaultDisplayer;
    }

    void clear() {
        this.displayers.clear();
    }
}

