/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import java.util.HashMap;
import java.util.Map;

public class Boolean
extends AbstractAnumMeaning {
    private static Map<String, ValidBoolean> data = new HashMap<String, ValidBoolean>();
    private boolean detectedNeg;
    private boolean detectedPos;
    private boolean detectedNonLiteralTrueOrFalse;

    public static String opposite(String b) {
        ValidBoolean vb = data.get(b);
        if (vb == null) {
            return null;
        }
        return "" + !vb.val;
    }

    public java.lang.Boolean parseNoFail(String v) {
        if (v == null) {
            return null;
        }
        ValidBoolean vb = data.get(v.toLowerCase());
        if (vb == null) {
            return null;
        }
        return vb.val;
    }

    public boolean parse(String v) {
        if (v == null) {
            throw new NumberFormatException("Invalid boolean data " + v);
        }
        ValidBoolean vb = data.get(v.toLowerCase());
        if (vb == null) {
            throw new NumberFormatException("Invalid boolean data " + v);
        }
        return vb.val;
    }

    @Override
    public double detects(String v) {
        if (v == null || v.isEmpty()) {
            return 0.0;
        }
        ValidBoolean vb = data.get(v.toLowerCase());
        if (vb == null) {
            return 0.0;
        }
        if (vb.val) {
            this.detectedPos = true;
        } else {
            this.detectedNeg = true;
        }
        if (!vb.originalWasLiteralTrueOrFalse) {
            this.detectedNonLiteralTrueOrFalse = true;
        }
        return vb.score;
    }

    public boolean hasBothPositiveAndNegative() {
        return this.detectedNeg && this.detectedPos;
    }

    public boolean hasNonLiteralTrueOrFalseValues() {
        return this.detectedNonLiteralTrueOrFalse;
    }

    static {
        data.put("true", new ValidBoolean(true, 0.7, true));
        data.put("false", new ValidBoolean(false, 0.7, true));
        data.put("yes", new ValidBoolean(true, 0.2, false));
        data.put("no", new ValidBoolean(false, 0.2, false));
        data.put("1", new ValidBoolean(true, 0.2, false));
        data.put("0", new ValidBoolean(false, 0.2, false));
        data.put("y", new ValidBoolean(true, 0.1, false));
        data.put("n", new ValidBoolean(false, 0.1, false));
        data.put("t", new ValidBoolean(true, 0.1, false));
        data.put("f", new ValidBoolean(false, 0.1, false));
        data.put("o", new ValidBoolean(true, 0.1, false));
    }

    static class ValidBoolean {
        boolean val;
        double score;
        boolean originalWasLiteralTrueOrFalse;

        ValidBoolean(boolean val, double score, boolean originalWasLiteralTrueOrFalse) {
            this.val = val;
            this.score = score;
            this.originalWasLiteralTrueOrFalse = originalWasLiteralTrueOrFalse;
        }
    }
}

