/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.oauth;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.WebBrowserOAuthClient;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.hivecommon.utils.OAuthTokenCache;
import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.OAuthUtil;
import com.databricks.client.jdbc.oauth.OauthProvider;
import com.databricks.client.jdbc.oauth.RefreshTokenExpiredException;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.entity.UrlEncodedFormEntity;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.databricks.client.jdbc42.internal.apache.http.message.BasicNameValuePair;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Random;

public class AuthorizationCodeOAuthProvider
extends OauthProvider {
    private final int OAUTH2_CODE_VERIFIER_GEN_LENGTH = 200;
    private final int OAUTH2_CODE_VERIFIER_MIN_LENGTH = 50;
    private final String OAUTH2_REDIRECTURL_STR = "redirect_uri";
    private final String OAUTH2_CODE_CHALLENGE_STR = "code_challenge";
    private final String OAUTH2_CODE_CHALLENGE_METHOD_STR = "code_challenge_method";
    private final String OAUTH2_STATE_STR = "state";
    private final String OAUTH2_CODE_RESPONSE_TYPE_STR = "response_type=code&";
    private final String HTTP_LOCALHOST_PREFIX = "http://localhost:";
    private final String BROWSER_CRED_GRANT = "authorization_code";
    private final String CODE = "code";
    private final String REDIRECT_URI = "redirect_uri";
    private final String CODE_VERIFIER = "code_verifier";
    private OAuthTokenCache m_refreshTokenCache;
    private OAuthTokenCache m_accessTokenCache;
    private WebBrowserOAuthClient m_browserClient = null;
    private String m_codeVerifier;

    public AuthorizationCodeOAuthProvider(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        super(hiveJDBCSettings, iLogger);
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_refreshTokenCache = new OAuthTokenCache(iLogger, this.m_settings, "refresh");
        this.m_accessTokenCache = new OAuthTokenCache(iLogger, this.m_settings, "access");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void obtainAccessToken() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasValidAccessTokenJwtExpiry()) {
            return;
        }
        var1_1 = false;
        var2_2 = this.m_settings.m_host + ".accesskey";
        var3_3 = this.m_settings.m_host;
        if (this.m_settings.m_enableTokenCache.booleanValue()) {
            try {
                var4_4 = null;
                var5_7 = null;
                try {
                    var4_4 = this.m_accessTokenCache.getTokenCache().getValue(var2_2);
                    var5_7 = this.m_refreshTokenCache.getTokenCache().getValue(var3_3);
                    if (!this.m_settings.m_expiredCachedAccessTokenTest.isEmpty()) {
                        LogUtilities.logDebug("Expired Cached Access Token Test is enabled.This code is for test purpose.", this.m_logger);
                        var4_4 = this.m_settings.m_expiredCachedAccessTokenTest;
                    }
                    if (!this.m_settings.m_expiredCachedRefreshTokenTest.isEmpty()) {
                        LogUtilities.logDebug("Expired Cached Access Token Test is enabled.This code is for test purpose.", this.m_logger);
                        var5_7 = this.m_settings.m_expiredCachedRefreshTokenTest;
                    }
                }
                catch (Exception var6_9) {
                    LogUtilities.logWarning(String.format("Got an Exception while retrieving Token Cache. Exception: %s", new Object[]{var6_9.getMessage()}), this.m_logger);
                }
                if (this.hasValidAccessTokenJwtExpiry()) ** GOTO lbl65
                if (var4_4 != null && !OAuthUtil.isAccessTokenExpired(var4_4, this.m_settings.m_oAuthSettings.m_tokenExpiryBuffer)) {
                    LogUtilities.logDebug("Cached access token is still valid. Driver will try to use this access token.", this.m_logger);
                    this.m_settings.m_oAuthSettings.m_accessToken = var4_4;
                    this.decodeAndExchangeAccessToken(false);
                }
                try {
                    if (var5_7 != null) {
                        LogUtilities.logDebug("Setting cached refresh token to get access token.", this.m_logger);
                        this.m_settings.m_oAuthSettings.m_refreshToken = var5_7;
                        if (this.m_settings.m_enableTestOverrideAuthorizationUrl.booleanValue()) {
                            this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpoint = this.m_settings.m_oAuthSettings.m_authorizationUrl;
                        }
                        this.getAccessTokenFromRefresh();
                        this.decodeAndExchangeAccessToken(this.m_oAuthSettings.m_enableMandatoryTokenExchange);
                        this.cacheToken(this.m_refreshTokenCache, var3_3, this.m_accessTokenCache, var2_2);
                    }
                    var1_1 = true;
                }
                catch (ErrorException var6_10) {
                    if (var6_10 instanceof RefreshTokenExpiredException) {
                        var1_1 = true;
                        LogUtilities.logError("Error occured during access token request using refresh token.", this.m_logger);
                        if (var6_10.getMessageParams() != null && var6_10.getMessageParams().length > 0) {
                            for (String var10_18 : var6_10.getMessageParams()) {
                                LogUtilities.logError("Following error occured while getting the new access token. " + var10_18, this.m_logger);
                            }
                        }
                        try {
                            if (this.m_refreshTokenCache.getTokenCache().getValue(var3_3) == null) ** GOTO lbl65
                            this.m_refreshTokenCache.getTokenCache().setValue(var3_3, this.m_refreshTokenCache.getTokenCache().getValue(var3_3), 0L);
                        }
                        catch (Exception var7_13) {
                            LogUtilities.logWarning(String.format("Got an Exception while retrieving and setting Token Cache. Exception: %s", new Object[]{var7_13.getMessage()}), this.m_logger);
                        }
                    }
                    var7_14 = this.getDetailedErrorExceptionMessage(var6_10);
                    var8_16 = new TException(var7_14, var6_10.getCause());
                    throw var8_16;
                }
            }
            catch (Exception var4_5) {
                var5_8 = new TException(var4_5.getMessage(), var4_5.getCause());
                throw var5_8;
            }
        } else if (!this.hasValidAccessTokenJwtExpiry()) {
            var1_1 = true;
        }
lbl65:
        // 10 sources

        if (var1_1) {
            try {
                this.getBrowserSSODetails();
                this.browerCredentialOauth(this.m_refreshTokenCache, var3_3, this.m_accessTokenCache, var2_2);
                this.decodeAndExchangeAccessToken(this.m_oAuthSettings.m_enableMandatoryTokenExchange);
                if (this.m_settings.m_enableTokenCache.booleanValue()) {
                    this.cacheToken(this.m_refreshTokenCache, var3_3, this.m_accessTokenCache, var2_2);
                }
            }
            catch (ErrorException var4_6) {
                var5_7 = this.getDetailedErrorExceptionMessage(var4_6);
                var6_11 = new TException(var5_7, var4_6.getCause());
                throw var6_11;
            }
        }
        this.addCustomOAuthHeader("Authorization", "Bearer " + this.m_oAuthSettings.m_accessToken);
    }

    private void browerCredentialOauth(OAuthTokenCache oAuthTokenCache, String string, OAuthTokenCache oAuthTokenCache2, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        OAuthSettings oAuthSettings = this.m_settings.m_oAuthSettings;
        URI uRI = OAuthUtil.getServerURI(oAuthSettings.m_authorizationUrl, oAuthSettings.m_OAuth2EnableAuthURLIPRange);
        String string3 = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = this.setRequestParams(oAuthSettings, httpPost);
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        string3 = this.executeRequestWithRetry(uRI, httpPost);
        this.parseTokenResponse(string3);
    }

    private void getBrowserSSODetails() throws TTransportException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.m_browserClient = new WebBrowserOAuthClient(this.m_settings, this.m_logger);
            this.checkDriverConfigurations();
            String string = String.valueOf(this.m_browserClient.getPort());
            String string2 = this.generateBrowserConnectionString(string);
            this.m_browserClient.setSSOUri(new URI(string2.replace(" ", "%20")));
            this.m_browserClient.doBrowserSSO();
            if (this.m_browserClient.isSuccess()) {
                if (!this.m_settings.m_enableTestOverrideAuthorizationUrl.booleanValue()) {
                    this.m_settings.m_oAuthSettings.m_authorizationUrl = this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpoint;
                }
            } else {
                if (this.m_browserClient.hasResponse()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_BROWSER_AUTH_FAILED_WITH_MSG.name(), "");
                    throw errorException;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_RESPONSE_TIMEOUT.name());
                throw errorException;
            }
            this.m_settings.m_oAuthSettings.m_code = this.m_browserClient.getCode();
            this.m_settings.m_oAuthSettings.m_redirectUri = "http://localhost:" + string;
            this.m_settings.m_oAuthSettings.m_codeVerifier = this.m_codeVerifier;
        }
        catch (ErrorException errorException) {
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            throw new TTransportException(errorException);
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_INVALID_URL_RECEIVED.name());
            String string = this.getDetailedErrorExceptionMessage(errorException);
            TException tException = new TException(string, uRISyntaxException.getCause());
            throw new TTransportException(tException);
        }
    }

    private void checkDriverConfigurations() throws ErrorException {
        if (!this.m_settings.m_serverSSLSettings.m_enableSSL) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSL_NOT_ENABLED.name(), this.m_settings.m_authMech.getDisplayName());
            throw errorException;
        }
    }

    private String generateBrowserConnectionString(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = this.generateCodeChallenge();
        String string3 = this.m_codeVerifier.substring(this.m_codeVerifier.length() / 2);
        String string4 = this.m_settings.m_oAuthSettings.m_Oauth2AuthorizeEndpoint + "?" + "response_type=code&" + "client_id" + "=" + this.m_settings.m_oAuthSettings.m_authClientID + "&" + "code_challenge" + "=" + string2 + "&" + "redirect_uri" + "=" + "http://localhost:" + string + "&" + "scope" + "=" + this.m_settings.m_oAuthSettings.m_authScope + "&" + "code_challenge_method" + "=" + this.m_settings.m_oAuthSettings.m_OAuth2CodeChallengeMethod + "&" + "state" + "=" + string3;
        if (this.m_settings.m_oAuthSettings.m_authClientSecret != null) {
            string4 = string4 + "&client_secret=" + this.m_settings.m_oAuthSettings.m_authClientSecret;
        }
        return string4;
    }

    private String generateCodeChallenge() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_codeVerifier = "";
        String string = "";
        try {
            Object object;
            Object object2;
            while (50 > this.m_codeVerifier.length()) {
                object2 = new byte[200];
                new Random().nextBytes((byte[])object2);
                object = new String((byte[])object2, Charset.forName("UTF-8"));
                this.m_codeVerifier = this.m_codeVerifier + ((String)object).replaceAll("[^a-zA-Z0-9]+", "");
            }
            object2 = MessageDigest.getInstance("SHA-256");
            object = ((MessageDigest)object2).digest(this.m_codeVerifier.getBytes(Charset.forName("UTF-8")));
            byte[] byArray = Base64.getEncoder().encode((byte[])object);
            string = new String(byArray);
            string = string.replaceAll("\\+", "-");
            string = string.replaceAll("/", "_");
            while (Character.compare(string.charAt(string.length() - 1), '=') == 0) {
                string = string.replace("=", "");
            }
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.OAUTH_FAILED_CODE_CHALLENGE.name(), exception.getMessage());
            throw errorException;
        }
        return string;
    }

    private void cacheToken(OAuthTokenCache oAuthTokenCache, String string, OAuthTokenCache oAuthTokenCache2, String string2) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string3 = this.m_oAuthSettings.m_accessToken;
        String string4 = this.m_oAuthSettings.m_refreshToken;
        long l = (this.m_oAuthSettings.m_expiryTime - System.currentTimeMillis()) / 1000L > 0L ? (this.m_oAuthSettings.m_expiryTime - System.currentTimeMillis()) / 1000L : 0L;
        try {
            if (string3 != null && !string3.isEmpty() && l != 0L) {
                LogUtilities.logDebug("Caching the access token.", this.m_logger);
                oAuthTokenCache2.getTokenCache().setValue(string2, string3, l);
            }
            if (string4 != null && !string4.isEmpty()) {
                LogUtilities.logDebug("Caching  the refresh token.", this.m_logger);
                oAuthTokenCache.getTokenCache().setValue(string, string4, Instant.now().getEpochSecond() * 2L);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning(String.format("Got an Exception while setting Token Cache. Exception: %s", exception.getMessage()), this.m_logger);
        }
    }

    protected final HttpPost setRequestParams(OAuthSettings oAuthSettings, HttpPost httpPost) throws ErrorException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        arrayList.add(new BasicNameValuePair("grant_type", "authorization_code"));
        arrayList.add(new BasicNameValuePair("client_id", oAuthSettings.m_authClientID));
        arrayList.add(new BasicNameValuePair("code", oAuthSettings.m_code));
        arrayList.add(new BasicNameValuePair("redirect_uri", oAuthSettings.m_redirectUri));
        arrayList.add(new BasicNameValuePair("code_verifier", oAuthSettings.m_codeVerifier));
        if (null != oAuthSettings.m_authScope) {
            arrayList.add(new BasicNameValuePair("scope", oAuthSettings.m_authScope));
        }
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, "UTF-8"));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        return httpPost;
    }
}

