/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift;

import com.databricks.client.jdbc42.internal.apache.thrift.TBase;
import com.databricks.client.jdbc42.internal.apache.thrift.TBaseHelper;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.apache.thrift.TFieldIdEnum;
import com.databricks.client.jdbc42.internal.apache.thrift.annotation.Nullable;
import com.databricks.client.jdbc42.internal.apache.thrift.meta_data.FieldMetaData;
import com.databricks.client.jdbc42.internal.apache.thrift.meta_data.FieldValueMetaData;
import com.databricks.client.jdbc42.internal.apache.thrift.meta_data.ListMetaData;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TCompactProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TField;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TList;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocolException;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocolUtil;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TStruct;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TTupleProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.IScheme;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.SchemeFactory;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.StandardScheme;
import com.databricks.client.jdbc42.internal.apache.thrift.scheme.TupleScheme;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TIOStreamTransport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TDoubleColumn
implements TBase<TDoubleColumn, _Fields>,
Serializable,
Cloneable,
Comparable<TDoubleColumn> {
    private static final TStruct STRUCT_DESC = new TStruct("TDoubleColumn");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField NULLS_FIELD_DESC = new TField("nulls", 11, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TDoubleColumnStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TDoubleColumnTupleSchemeFactory();
    @Nullable
    private List<Double> values;
    @Nullable
    private ByteBuffer nulls;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TDoubleColumn() {
    }

    public TDoubleColumn(List<Double> list, ByteBuffer byteBuffer) {
        this();
        this.values = list;
        this.nulls = TBaseHelper.copyBinary(byteBuffer);
    }

    public TDoubleColumn(TDoubleColumn tDoubleColumn) {
        if (tDoubleColumn.isSetValues()) {
            ArrayList<Double> arrayList = new ArrayList<Double>(tDoubleColumn.values);
            this.values = arrayList;
        }
        if (tDoubleColumn.isSetNulls()) {
            this.nulls = TBaseHelper.copyBinary(tDoubleColumn.nulls);
        }
    }

    @Override
    public TDoubleColumn deepCopy() {
        return new TDoubleColumn(this);
    }

    @Override
    public void clear() {
        this.values = null;
        this.nulls = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    @Nullable
    public Iterator<Double> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(double d) {
        if (this.values == null) {
            this.values = new ArrayList<Double>();
        }
        this.values.add(d);
    }

    @Nullable
    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(@Nullable List<Double> list) {
        this.values = list;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean bl) {
        if (!bl) {
            this.values = null;
        }
    }

    public byte[] getNulls() {
        this.setNulls(TBaseHelper.rightSize(this.nulls));
        return this.nulls == null ? null : this.nulls.array();
    }

    public ByteBuffer bufferForNulls() {
        return TBaseHelper.copyBinary(this.nulls);
    }

    public void setNulls(byte[] byArray) {
        this.nulls = byArray == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])byArray.clone());
    }

    public void setNulls(@Nullable ByteBuffer byteBuffer) {
        this.nulls = TBaseHelper.copyBinary(byteBuffer);
    }

    public void unsetNulls() {
        this.nulls = null;
    }

    public boolean isSetNulls() {
        return this.nulls != null;
    }

    public void setNullsIsSet(boolean bl) {
        if (!bl) {
            this.nulls = null;
        }
    }

    @Override
    public void setFieldValue(_Fields _Fields2, @Nullable Object object) {
        switch (_Fields2) {
            case VALUES: {
                if (object == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)object);
                break;
            }
            case NULLS: {
                if (object == null) {
                    this.unsetNulls();
                    break;
                }
                if (object instanceof byte[]) {
                    this.setNulls((byte[])object);
                    break;
                }
                this.setNulls((ByteBuffer)object);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields _Fields2) {
        switch (_Fields2) {
            case VALUES: {
                return this.getValues();
            }
            case NULLS: {
                return this.getNulls();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields _Fields2) {
        if (_Fields2 == null) {
            throw new IllegalArgumentException();
        }
        switch (_Fields2) {
            case VALUES: {
                return this.isSetValues();
            }
            case NULLS: {
                return this.isSetNulls();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TDoubleColumn) {
            return this.equals((TDoubleColumn)object);
        }
        return false;
    }

    public boolean equals(TDoubleColumn tDoubleColumn) {
        if (tDoubleColumn == null) {
            return false;
        }
        if (this == tDoubleColumn) {
            return true;
        }
        boolean bl = this.isSetValues();
        boolean bl2 = tDoubleColumn.isSetValues();
        if (bl || bl2) {
            if (!bl || !bl2) {
                return false;
            }
            if (!this.values.equals(tDoubleColumn.values)) {
                return false;
            }
        }
        boolean bl3 = this.isSetNulls();
        boolean bl4 = tDoubleColumn.isSetNulls();
        if (bl3 || bl4) {
            if (!bl3 || !bl4) {
                return false;
            }
            if (!this.nulls.equals(tDoubleColumn.nulls)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = n * 8191 + (this.isSetValues() ? 131071 : 524287);
        if (this.isSetValues()) {
            n = n * 8191 + this.values.hashCode();
        }
        n = n * 8191 + (this.isSetNulls() ? 131071 : 524287);
        if (this.isSetNulls()) {
            n = n * 8191 + this.nulls.hashCode();
        }
        return n;
    }

    @Override
    public int compareTo(TDoubleColumn tDoubleColumn) {
        if (!this.getClass().equals(tDoubleColumn.getClass())) {
            return this.getClass().getName().compareTo(tDoubleColumn.getClass().getName());
        }
        int n = 0;
        n = Boolean.valueOf(this.isSetValues()).compareTo(tDoubleColumn.isSetValues());
        if (n != 0) {
            return n;
        }
        if (this.isSetValues() && (n = TBaseHelper.compareTo(this.values, tDoubleColumn.values)) != 0) {
            return n;
        }
        n = Boolean.valueOf(this.isSetNulls()).compareTo(tDoubleColumn.isSetNulls());
        if (n != 0) {
            return n;
        }
        if (this.isSetNulls() && (n = TBaseHelper.compareTo(this.nulls, tDoubleColumn.nulls)) != 0) {
            return n;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int n) {
        return _Fields.findByThriftId(n);
    }

    @Override
    public void read(TProtocol tProtocol) throws TException {
        TDoubleColumn.scheme(tProtocol).read(tProtocol, (TDoubleColumn)this);
    }

    @Override
    public void write(TProtocol tProtocol) throws TException {
        TDoubleColumn.scheme(tProtocol).write(tProtocol, (TDoubleColumn)this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TDoubleColumn(");
        boolean bl = true;
        stringBuilder.append("values:");
        if (this.values == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.values);
        }
        bl = false;
        if (!bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("nulls:");
        if (this.nulls == null) {
            stringBuilder.append("null");
        } else {
            TBaseHelper.toString(this.nulls, stringBuilder);
        }
        bl = false;
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void validate() throws TException {
        if (!this.isSetValues()) {
            throw new TProtocolException("Required field 'values' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNulls()) {
            throw new TProtocolException("Required field 'nulls' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(objectOutputStream)));
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(objectInputStream)));
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol tProtocol) {
        return (StandardScheme.class.equals(tProtocol.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> enumMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        enumMap.put(_Fields.VALUES, new FieldMetaData("values", 1, new ListMetaData(15, new FieldValueMetaData(4))));
        enumMap.put(_Fields.NULLS, new FieldMetaData("nulls", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(enumMap);
        FieldMetaData.addStructMetaDataMap(TDoubleColumn.class, metaDataMap);
    }

    private static class TDoubleColumnTupleScheme
    extends TupleScheme<TDoubleColumn> {
        private TDoubleColumnTupleScheme() {
        }

        @Override
        public void write(TProtocol tProtocol, TDoubleColumn tDoubleColumn) throws TException {
            TTupleProtocol tTupleProtocol = (TTupleProtocol)tProtocol;
            tTupleProtocol.writeI32(tDoubleColumn.values.size());
            Iterator iterator = tDoubleColumn.values.iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                tTupleProtocol.writeDouble(d);
            }
            tTupleProtocol.writeBinary(tDoubleColumn.nulls);
        }

        @Override
        public void read(TProtocol tProtocol, TDoubleColumn tDoubleColumn) throws TException {
            TTupleProtocol tTupleProtocol = (TTupleProtocol)tProtocol;
            TList tList = new TList(4, tTupleProtocol.readI32());
            tDoubleColumn.values = new ArrayList(tList.size);
            for (int i = 0; i < tList.size; ++i) {
                double d = tTupleProtocol.readDouble();
                tDoubleColumn.values.add(d);
            }
            tDoubleColumn.setValuesIsSet(true);
            tDoubleColumn.nulls = tTupleProtocol.readBinary();
            tDoubleColumn.setNullsIsSet(true);
        }
    }

    private static class TDoubleColumnTupleSchemeFactory
    implements SchemeFactory {
        private TDoubleColumnTupleSchemeFactory() {
        }

        public TDoubleColumnTupleScheme getScheme() {
            return new TDoubleColumnTupleScheme();
        }
    }

    private static class TDoubleColumnStandardScheme
    extends StandardScheme<TDoubleColumn> {
        private TDoubleColumnStandardScheme() {
        }

        @Override
        public void read(TProtocol tProtocol, TDoubleColumn tDoubleColumn) throws TException {
            tProtocol.readStructBegin();
            while (true) {
                TField tField = tProtocol.readFieldBegin();
                if (tField.type == 0) break;
                switch (tField.id) {
                    case 1: {
                        if (tField.type == 15) {
                            TList tList = tProtocol.readListBegin();
                            tDoubleColumn.values = new ArrayList(tList.size);
                            for (int i = 0; i < tList.size; ++i) {
                                double d = tProtocol.readDouble();
                                tDoubleColumn.values.add(d);
                            }
                            tProtocol.readListEnd();
                            tDoubleColumn.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(tProtocol, tField.type);
                        break;
                    }
                    case 2: {
                        if (tField.type == 11) {
                            tDoubleColumn.nulls = tProtocol.readBinary();
                            tDoubleColumn.setNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(tProtocol, tField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(tProtocol, tField.type);
                    }
                }
                tProtocol.readFieldEnd();
            }
            tProtocol.readStructEnd();
            tDoubleColumn.validate();
        }

        @Override
        public void write(TProtocol tProtocol, TDoubleColumn tDoubleColumn) throws TException {
            tDoubleColumn.validate();
            tProtocol.writeStructBegin(STRUCT_DESC);
            if (tDoubleColumn.values != null) {
                tProtocol.writeFieldBegin(VALUES_FIELD_DESC);
                tProtocol.writeListBegin(new TList(4, tDoubleColumn.values.size()));
                Iterator iterator = tDoubleColumn.values.iterator();
                while (iterator.hasNext()) {
                    double d = (Double)iterator.next();
                    tProtocol.writeDouble(d);
                }
                tProtocol.writeListEnd();
                tProtocol.writeFieldEnd();
            }
            if (tDoubleColumn.nulls != null) {
                tProtocol.writeFieldBegin(NULLS_FIELD_DESC);
                tProtocol.writeBinary(tDoubleColumn.nulls);
                tProtocol.writeFieldEnd();
            }
            tProtocol.writeFieldStop();
            tProtocol.writeStructEnd();
        }
    }

    private static class TDoubleColumnStandardSchemeFactory
    implements SchemeFactory {
        private TDoubleColumnStandardSchemeFactory() {
        }

        public TDoubleColumnStandardScheme getScheme() {
            return new TDoubleColumnStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values"),
        NULLS(2, "nulls");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int n) {
            switch (n) {
                case 1: {
                    return VALUES;
                }
                case 2: {
                    return NULLS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int n) {
            _Fields _Fields2 = _Fields.findByThriftId(n);
            if (_Fields2 == null) {
                throw new IllegalArgumentException("Field " + n + " doesn't exist!");
            }
            return _Fields2;
        }

        @Nullable
        public static _Fields findByName(String string) {
            return byName.get(string);
        }

        private _Fields(short s, String string2) {
            this._thriftId = s;
            this._fieldName = string2;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields _Fields2 : EnumSet.allOf(_Fields.class)) {
                byName.put(_Fields2.getFieldName(), _Fields2);
            }
        }
    }
}

