/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;

public final class ETHourFn
extends ETScalarFn {
    public ETHourFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        if (1 != list.size() || 1 != list2.size()) {
            throw new IllegalArgumentException("Invalid Number of arguments for HOUR scalar function.");
        }
        short s = list2.get(0).getTypeMetadata().getType();
        if (92 != s) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getLogString() {
        return "ETHourFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            int n = iSqlDataWrapper.getTime().getHours();
            eTDataRequest.getData().setSmallInt(n);
        }
        return false;
    }
}

