/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity.filterutils;

import com.dataiku.dip.activity.filterutils.FilterReportBuilder;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dashboards.insights.chart.ChartInsightMeta;
import com.dataiku.dip.dashboards.insights.chart.ChartInsightParams;
import com.dataiku.dip.dashboards.insights.dataset.DatasetTableInsightMeta;
import com.dataiku.dip.dashboards.insights.dataset.DatasetTableInsightParams;
import com.dataiku.dip.dashboards.insights.filters.FiltersInsightTileParams;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.update.UpdateRecipeParams;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.recipes.eda.EDARecipeParams;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterTraverser {
    private static final String PRE_FILTER = "preFilter";
    private static final String POST_FILTER = "postFilter";
    private static final String SPLIT = "split";
    private static final String TOPN = "topn";
    private static final String GROUPING = "grouping";
    private static final String PIVOT = "pivot";
    private static final String DISTINCT = "distinct";
    private static final String SORT = "sort";
    private static final String WINDOW = "window";
    private static final String SAMPLING = "sampling";
    private static final String JOIN = "join";
    private static final String GEO_JOIN = "geojoin";
    private static final String STACK_TYPE = "vstack";
    private static final String STACK_KEY = "stack";
    private static final String EDA_PCA = "eda_pca";
    private static final String EDA_STATS = "eda_stats";
    private static final String EDA_UNIVARIATE = "eda_univariate";
    private static final String PUSH_TO_EDITABLE_TYPE = "update";
    private static final String PUSH_TO_EDITABLE_KEY = "pushToEditable";
    private static final String PUSH_TO_EDITABLE_MAIN_FILTER = "pushedDataFilter";
    private static final String INSIGHT = "insight";
    private static final String ANALYSIS = "analysis";
    private static final String CHART = "chart";
    private static final String DASHBOARD = "dashboard";
    private static final String TILE = "tile";
    private static final String DATASET = "dataset";
    private static final String ASSERTION = "assertion";
    private static final String TRAIN_SPLIT = "trainSplit";
    private static final String TEST_SPLIT = "testSplit";
    private static final String SAMPLING_MAIN_FILTER = "samplingFilter";
    private static final String SPLITTING_MAIN_FILTER = "splittingFilter";
    private static final String DATASET_TABLE = "datasetTable";
    private static final String WORKSHEET = "worksheet";
    private static final String STATISTICS = "statistics";
    private static final String DATASET_EXPLORATORY_SAMPLING = "explorationSampling";
    private static final String ANALYSIS_EXPLORATORY_SAMPLING = "designSample";
    @Autowired
    private RecipesDAO recipesDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.usage");

    public FilterTraverser() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void traverseFilters(FilterReportBuilder reportBuilder, Worksheet worksheet) {
        if (worksheet != null && worksheet.dataSpec != null && worksheet.dataSpec.datasetSelection != null) {
            FilterTraverser.filtersFromDatasetSelection(reportBuilder, worksheet.dataSpec.datasetSelection, STATISTICS, WORKSHEET);
        }
    }

    public void traverseFilters(FilterReportBuilder reportBuilder, Insight insight) {
        ChartInsightParams chartInsightParams;
        if (insight == null) {
            return;
        }
        if (DatasetTableInsightMeta.META.getType().equals(insight.type)) {
            DatasetTableInsightParams tableInsightParams = insight.getParamsAs(DatasetTableInsightParams.class);
            FilterTraverser.filtersFromTableParams(reportBuilder, tableInsightParams);
        }
        if (ChartInsightMeta.META.getType().equals(insight.type) && (chartInsightParams = insight.getParamsAs(ChartInsightParams.class)) != null) {
            FilterTraverser.filtersFromRefreshableSelection(reportBuilder, chartInsightParams.refreshableSelection, INSIGHT, CHART);
        }
    }

    private static void filtersFromTableParams(FilterReportBuilder reportBuilder, DatasetTableInsightParams datasetTableParams) {
        if (datasetTableParams == null || datasetTableParams.shakerScript == null) {
            return;
        }
        SerializedShakerScript shakerScript = datasetTableParams.shakerScript;
        if (shakerScript.explorationSampling != null) {
            FilterTraverser.filterFromExplorationSampling(reportBuilder, shakerScript.explorationSampling, INSIGHT, DATASET_TABLE);
        }
    }

    private static void filterFromExplorationSampling(FilterReportBuilder reportBuilder, SerializedShakerScript.ShakerExplorationSampleSettings explorationSampling, String unit, String location) {
        if (explorationSampling.selection != null && explorationSampling.selection.filter != null) {
            reportBuilder.appendFilter(unit, location, explorationSampling.selection.filter);
        }
    }

    public void traverseFilters(FilterReportBuilder reportBuilder, AnalysisCoreParams analysisParams) {
        if (analysisParams == null || analysisParams.charts == null) {
            return;
        }
        for (AnalysisCoreParams.AnalysisChart chart : analysisParams.charts) {
            FilterTraverser.filtersFromRefreshableSelection(reportBuilder, chart.refreshableSelection, ANALYSIS, CHART);
        }
        if (analysisParams.script != null && analysisParams.script.explorationSampling != null) {
            FilterTraverser.filterFromExplorationSampling(reportBuilder, analysisParams.script.explorationSampling, ANALYSIS, ANALYSIS_EXPLORATORY_SAMPLING);
        }
    }

    private static void filtersFromRefreshableSelection(FilterReportBuilder reportBuilder, SerializedShakerScript.RefreshableStreamableSelection refreshableSelection, String unit, String location) {
        if (refreshableSelection != null && refreshableSelection.selection != null) {
            FilterTraverser.filtersFromDatasetSelection(reportBuilder, refreshableSelection.selection, unit, location);
        }
    }

    private static void filtersFromDatasetSelection(FilterReportBuilder reportBuilder, DatasetSelection datasetSelection, String unit, String location) {
        if (datasetSelection.filter != null) {
            reportBuilder.appendFilter(unit, location, datasetSelection.filter);
        }
    }

    public void traverseFilters(FilterReportBuilder reportBuilder, Dashboard dashboard) {
        if (dashboard.pages == null) {
            return;
        }
        for (DashboardPage page : dashboard.pages) {
            if (page.grid == null) continue;
            for (Tile tile : page.grid.tiles) {
                if (tile.tileType == null || tile.tileType != Tile.TileType.INSIGHT || !(tile.tileParams instanceof FiltersInsightTileParams)) continue;
                FilterTraverser.filtersFromRefreshableSelection(reportBuilder, ((FiltersInsightTileParams)tile.tileParams).refreshableSelection, DASHBOARD, TILE);
            }
        }
    }

    public void traverseFilters(FilterReportBuilder reportBuilder, DatasetExploreSettings exploreSettings) {
        if (exploreSettings == null) {
            return;
        }
        if (exploreSettings.charts != null) {
            for (DatasetExploreSettings.DatasetChart chart : exploreSettings.charts) {
                if (chart == null) continue;
                FilterTraverser.filtersFromRefreshableSelection(reportBuilder, chart.refreshableSelection, DATASET, CHART);
            }
        }
        if (exploreSettings.script != null && exploreSettings.script.explorationSampling != null) {
            FilterTraverser.filterFromExplorationSampling(reportBuilder, exploreSettings.script.explorationSampling, DATASET, DATASET_EXPLORATORY_SAMPLING);
        }
    }

    public void traverseFilters(FilterReportBuilder reportBuilder, PredictionMLTask mlTask) {
        MLAssertionsParams assertionParams;
        Optional<MLAssertionsParams> maybeParams = mlTask.getAssertionsParams();
        if (maybeParams.isPresent() && (assertionParams = maybeParams.get()).hasAssertions()) {
            for (MLAssertionsParams.MLAssertion assertion : assertionParams.assertions) {
                reportBuilder.appendFilter(ANALYSIS, ASSERTION, assertion.filter);
            }
        }
        FilterTraverser.appendTestTrainFilters(reportBuilder, mlTask.splitParams);
    }

    private static void appendTestTrainFilters(FilterReportBuilder reportBuilder, SplitParams splitParams) {
        if (splitParams == null) {
            return;
        }
        if (splitParams.ttPolicy == SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_SINGLE_DATASET) {
            FilterTraverser.appendSplitFilter(reportBuilder, splitParams.efsdTrain, TRAIN_SPLIT);
            FilterTraverser.appendSplitFilter(reportBuilder, splitParams.efsdTest, TEST_SPLIT);
        } else if (splitParams.ttPolicy == SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_TWO_DATASETS) {
            FilterTraverser.appendSplitFilter(reportBuilder, splitParams.eftdTrain, TRAIN_SPLIT);
            FilterTraverser.appendSplitFilter(reportBuilder, splitParams.eftdTest, TEST_SPLIT);
        }
    }

    private static void appendSplitFilter(FilterReportBuilder reportBuilder, SplitParams.EFDSplit split, String location) {
        if (split != null && split.filter != null) {
            reportBuilder.appendFilter(ANALYSIS, location, split.filter);
        }
    }

    private <T> T loadRecipeParams(String projectKey, String name, Class<T> clazz) throws IOException {
        String payload = this.recipesDAO.getPayloadOrNull(projectKey, name);
        return (T)JSON.parse((String)payload, clazz);
    }

    public void traverseFilters(FilterReportBuilder reportBuilder, SerializedRecipe sr) throws IOException {
        switch (sr.type) {
            case "split": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, SplitRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "topn": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, TopNRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "grouping": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, GroupingRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "pivot": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, PivotRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "distinct": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, DistinctRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "sort": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, SortRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "window": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, WindowRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "join": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, JoinRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "geojoin": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, GeoJoinRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "vstack": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, VStackRecipePayloadParams.class), reportBuilder);
                break;
            }
            case "update": {
                this.filtersFromRecipeParams(this.loadRecipeParams(sr.projectKey, sr.name, UpdateRecipeParams.class), reportBuilder);
                break;
            }
            case "eda_pca": 
            case "eda_univariate": 
            case "eda_stats": {
                StatsTestRecipePayloadParams payloadParams;
                EDARecipeParams params = null;
                try {
                    params = sr.getParamsAs(EDARecipeParams.class);
                }
                catch (ClassCastException e) {
                    logger.warn((Object)("Error while extracting filters from recipe: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
                Object recipeType = sr.type;
                if (EDA_STATS.equals(sr.type) && (payloadParams = this.loadRecipeParams(sr.projectKey, sr.name, StatsTestRecipePayloadParams.class)) != null) {
                    recipeType = sr.type + "-" + payloadParams.getType();
                }
                this.filtersFromRecipeParams(params, reportBuilder, (String)recipeType);
                break;
            }
            case "sampling": {
                FilterDesc samplingFilter = this.loadRecipeParams(sr.projectKey, sr.name, FilterDesc.class);
                reportBuilder.appendFilter(SAMPLING, SAMPLING_MAIN_FILTER, samplingFilter);
                break;
            }
        }
    }

    void filtersFromRecipeParams(TopNRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            reportBuilder.appendFilter(TOPN, PRE_FILTER, params.preFilter);
        }
    }

    void filtersFromRecipeParams(PivotRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            reportBuilder.appendFilter(PIVOT, PRE_FILTER, params.preFilter);
        }
    }

    void filtersFromRecipeParams(SortRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            reportBuilder.appendFilter(SORT, PRE_FILTER, params.preFilter);
        }
    }

    void filtersFromRecipeParams(GroupingRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            reportBuilder.appendFilter(GROUPING, PRE_FILTER, params.preFilter);
            reportBuilder.appendFilter(GROUPING, POST_FILTER, params.postFilter);
        }
    }

    void filtersFromRecipeParams(DistinctRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            reportBuilder.appendFilter(DISTINCT, PRE_FILTER, params.preFilter);
            reportBuilder.appendFilter(DISTINCT, POST_FILTER, params.postFilter);
        }
    }

    void filtersFromRecipeParams(WindowRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            reportBuilder.appendFilter(WINDOW, PRE_FILTER, params.preFilter);
            reportBuilder.appendFilter(WINDOW, POST_FILTER, params.postFilter);
        }
    }

    void filtersFromRecipeParams(VStackRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            for (VStackRecipePayloadParams.InputDesc inputDesc : params.getVirtualInputs()) {
                reportBuilder.appendFilter(STACK_KEY, PRE_FILTER, inputDesc.preFilter);
            }
            reportBuilder.appendFilter(STACK_KEY, POST_FILTER, params.postFilter);
        }
    }

    void filtersFromRecipeParams(JoinRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            for (JoinRecipePayloadParams.InputDesc inputDesc : params.getVirtualInputs()) {
                reportBuilder.appendFilter(JOIN, PRE_FILTER, inputDesc.preFilter);
            }
            reportBuilder.appendFilter(JOIN, POST_FILTER, params.postFilter);
        }
    }

    void filtersFromRecipeParams(GeoJoinRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            for (JoinInputDescBase inputDesc : params.getVirtualInputs()) {
                reportBuilder.appendFilter(GEO_JOIN, PRE_FILTER, inputDesc.preFilter);
            }
            reportBuilder.appendFilter(GEO_JOIN, POST_FILTER, params.postFilter);
        }
    }

    void filtersFromRecipeParams(SplitRecipePayloadParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            if (params.hasPrefilter()) {
                reportBuilder.appendFilter(SPLIT, PRE_FILTER, params.preFilter);
            }
            if (SplitRecipePayloadParams.Mode.FILTERS.equals((Object)params.mode)) {
                for (SplitRecipePayloadParams.FilterSplitDesc filterSplitDesc : params.filterSplits) {
                    if (filterSplitDesc.filter == null) continue;
                    reportBuilder.appendFilter(SPLIT, SPLITTING_MAIN_FILTER, filterSplitDesc.filter);
                }
            }
        }
    }

    void filtersFromRecipeParams(UpdateRecipeParams params, FilterReportBuilder reportBuilder) {
        if (params != null) {
            reportBuilder.appendFilter(PUSH_TO_EDITABLE_KEY, PUSH_TO_EDITABLE_MAIN_FILTER, params.filter);
        }
    }

    void filtersFromRecipeParams(EDARecipeParams params, FilterReportBuilder reportBuilder, String recipeType) {
        StreamableDatasetSelection datasetSelection;
        if (params != null && (datasetSelection = params.getDatasetSelection()) != null && datasetSelection.filter != null) {
            reportBuilder.appendFilter(recipeType, PRE_FILTER, datasetSelection.filter);
        }
    }
}

